/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.conversion.mapper;

import java.util.LinkedHashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.srplib.contract.Argument;
import org.srplib.conversion.mapper.MatcherMapConverter;

public class MatcherMapBuilder<I, O> {
    private Map<Matcher<I>, O> matcherMap;
    private O defaultValue;
    private boolean throwExceptionOnNoMatch = true;
    private String noMatchMessagePattern = "No matching value for '%s'.";

    public static <I, O> MatcherMapBuilder<I, O> create() {
        return new MatcherMapBuilder<I, O>();
    }

    public static <I, O> MatcherMapBuilder<I, O> create(Map<I, O> map) {
        MatcherMapBuilder<I, O> mapper = MatcherMapBuilder.create();
        for (I key : map.keySet()) {
            mapper.map(key, map.get(key));
        }
        return mapper;
    }

    public MatcherMapBuilder() {
        this.matcherMap = new LinkedHashMap<Matcher<I>, O>();
        this.defaultValue = null;
    }

    public MatcherMapBuilder(Map<Matcher<I>, O> matcherMap, O defaultValue) {
        Argument.checkNotNull(matcherMap, (String)"Matcher map must not be null!", (Object[])new Object[0]);
        this.matcherMap = matcherMap;
        this.defaultValue = defaultValue;
    }

    public MatcherMapBuilder<I, O> setDefaultValue(O defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public MatcherMapBuilder<I, O> setNoMatchMessagePattern(String pattern) {
        this.noMatchMessagePattern = pattern;
        return this;
    }

    public MatcherMapBuilder<I, O> throwExceptionOnNoMatch(boolean throwExceptionOnNoMatch) {
        this.throwExceptionOnNoMatch = throwExceptionOnNoMatch;
        return this;
    }

    public MatcherMapBuilder<I, O> map(Matcher<I> matcher, O value) {
        this.matcherMap.put(matcher, value);
        return this;
    }

    public MatcherMapBuilder<I, O> map(I input, O output) {
        this.matcherMap.put(Is.is(input), output);
        return this;
    }

    public MatcherMapConverter<I, O> build() {
        MatcherMapConverter<I, O> matcherConverter = new MatcherMapConverter<I, O>(this.matcherMap);
        matcherConverter.setDefaultValue(this.defaultValue);
        matcherConverter.setNoMatchMessagePattern(this.noMatchMessagePattern);
        matcherConverter.setThrowExceptionOnNoMatch(this.throwExceptionOnNoMatch);
        return matcherConverter;
    }
}

