/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.conversion;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.srplib.contract.Argument;
import org.srplib.conversion.Converter;

public class DateToStringConverter
implements Converter<Date, String> {
    private static final String ISO_DATE_PATTERN = "yyyy-MM-dd";
    private static final String NULL_DATE_STRING = "";
    private String format;

    public DateToStringConverter(String format) {
        Argument.checkNotNull((Object)format, (String)"format", (Object[])new Object[0]);
        this.createDateFormat(format);
        this.format = format;
    }

    public DateToStringConverter() {
        this(ISO_DATE_PATTERN);
    }

    public String convert(Date input) {
        return input == null ? NULL_DATE_STRING : this.createDateFormat(this.format).format(input);
    }

    private SimpleDateFormat createDateFormat(String format) {
        return new SimpleDateFormat(format);
    }
}

