/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.conversion;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.srplib.conversion.ChainConverter;
import org.srplib.conversion.Converter;
import org.srplib.conversion.ConverterRegistry;
import org.srplib.conversion.EmptyConverter;
import org.srplib.conversion.EqualsConverter;
import org.srplib.conversion.IfConverter;
import org.srplib.conversion.IntegerToLongConverter;
import org.srplib.conversion.IntegerToStringConverter;
import org.srplib.conversion.StringToBooleanConverter;
import org.srplib.conversion.StringToDoubleConverter;
import org.srplib.conversion.StringToEnumConverter;
import org.srplib.conversion.StringToIntegerConverter;
import org.srplib.conversion.SwitchConverter;
import org.srplib.conversion.TwoWayConverter;

public class Converters {
    public static ConverterRegistry newRegistry() {
        return new ConverterRegistry();
    }

    public static ConverterRegistry newDefaultRegistry() {
        ConverterRegistry converters = new ConverterRegistry();
        converters.registerConverter(String.class, Double.class, (Converter)new StringToDoubleConverter());
        converters.registerConverter(String.class, Double.TYPE, (Converter)new StringToDoubleConverter());
        converters.registerConverter(String.class, Integer.class, (Converter)new StringToIntegerConverter());
        converters.registerConverter(String.class, Integer.TYPE, (Converter)new StringToIntegerConverter());
        converters.registerConverter(String.class, Boolean.class, (Converter)new StringToBooleanConverter());
        converters.registerConverter(String.class, Boolean.TYPE, (Converter)new StringToBooleanConverter());
        converters.registerConverter(Boolean.class, Boolean.TYPE, (Converter)EmptyConverter.instance());
        converters.registerConverter(Integer.class, String.class, (Converter)new IntegerToStringConverter());
        converters.registerConverter(Integer.TYPE, String.class, (Converter)new IntegerToStringConverter());
        converters.registerConverter(Integer.class, Long.class, (Converter)new IntegerToLongConverter());
        converters.registerConverter(Integer.class, Long.TYPE, (Converter)new IntegerToLongConverter());
        return converters;
    }

    public static <I, O> TwoWayConverter<I, O> empty() {
        return EmptyConverter.instance();
    }

    public static <T extends Enum> Converter<String, T> newStringToEnumConverter(Class<T> enumClass) {
        return new StringToEnumConverter<T>(enumClass);
    }

    public static <T> Converter<Boolean, T> choice(T trueValue, T falseValue) {
        return new IfConverter(trueValue, falseValue);
    }

    public static <I, O> Converter<I, O> choice(Map<I, O> map, O defaultValue) {
        return new SwitchConverter<I, O>(map, defaultValue);
    }

    public static <I, O> Converter<I, O> choice(Map<I, O> map) {
        return new SwitchConverter<I, O>(map);
    }

    public static <I, O> Converter<I, O> chain(Converter ... converters) {
        if (converters == null) {
            return Converters.empty();
        }
        return Converters.chain(Arrays.asList(converters));
    }

    public static <I, O> Converter<I, O> chain(List<Converter> converters) {
        ChainConverter result = converters == null || converters.isEmpty() ? Converters.empty() : (converters.size() == 1 ? converters.get(0) : new ChainConverter(converters));
        return result;
    }

    public static <T> Converter<T, Boolean> equal(T object) {
        return new EqualsConverter<T>(object);
    }
}

