/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.conversion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.srplib.contract.Argument;
import org.srplib.conversion.Converter;

public class ChainConverter<I, O>
implements Converter<I, O> {
    private List<Converter> converters = new ArrayList<Converter>();

    public ChainConverter(List<Converter> converters) {
        Argument.checkNotNull(converters, (String)"Converters list should not be null.", (Object[])new Object[0]);
        this.converters = converters;
    }

    public ChainConverter(Converter ... converters) {
        this(Arrays.asList(converters));
    }

    public O convert(I input) {
        Object value = input;
        for (Converter converter : this.converters) {
            value = converter.convert(value);
        }
        return (O)value;
    }
}

