/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.binding;

import java.util.ArrayList;
import java.util.List;
import org.srplib.binding.Binder;
import org.srplib.binding.Binding;
import org.srplib.binding.DefaultBinding;
import org.srplib.contract.Argument;
import org.srplib.contract.Assert;
import org.srplib.conversion.ConvertBackConverter;
import org.srplib.conversion.Converter;
import org.srplib.conversion.ConverterRegistry;
import org.srplib.conversion.EmptyConverter;
import org.srplib.conversion.TwoWayConverter;
import org.srplib.model.ContextDependentValueModel;
import org.srplib.model.ValueModel;
import org.srplib.validation.ValidationError;
import org.srplib.validation.ValidationErrors;
import org.srplib.validation.ValidationException;

public class ValueModelBinder<T>
implements Binder<T> {
    private List<Binding> bindings = new ArrayList<Binding>();
    private ConverterRegistry converterRegistry;

    public ValueModelBinder(List<Binding> bindings) {
        Argument.checkNotNull(bindings, (String)"binding", (Object[])new Object[0]);
        this.bindings = bindings;
        this.converterRegistry = this.createDefaultConverterRegistry();
    }

    private ConverterRegistry createDefaultConverterRegistry() {
        ConverterRegistry converterRegistry = new ConverterRegistry();
        return converterRegistry;
    }

    public ValueModelBinder() {
        this(new ArrayList<Binding>());
    }

    public ConverterRegistry getConverterRegistry() {
        return this.converterRegistry;
    }

    public void setConverterRegistry(ConverterRegistry converterRegistry) {
        this.converterRegistry = converterRegistry;
    }

    public void addBinding(Binding binding) {
        this.bindings.add(binding);
    }

    public void addBinding(ValueModel source, ValueModel target) {
        this.addBinding(new DefaultBinding(source, target));
    }

    @Override
    public void bind(T object) {
        for (Binding binding : this.bindings) {
            this.bind(object, binding);
        }
    }

    private void bind(T object, Binding binding) {
        ValueModel source = binding.getSource();
        this.setContextIfApplicable(object, source);
        ValueModel target = binding.getTarget();
        Object value = source.getValue();
        Converter converter = binding.getConverter() != null ? binding.getConverter() : this.getConverterNullSafe(source.getType(), target.getType());
        Object convertedValue = converter.convert(value);
        target.setValue(convertedValue);
    }

    @Override
    public T unbind(T object) {
        ValidationErrors validationErrors = this.unbind(object, new ValidationErrors(new ValidationError[0]));
        if (validationErrors.hasErrors()) {
            throw new ValidationException(validationErrors);
        }
        return object;
    }

    @Override
    public ValidationErrors unbind(T object, ValidationErrors errors) {
        for (Binding binding : this.bindings) {
            this.unbind(object, binding, errors);
        }
        return errors;
    }

    private void unbind(T object, Binding binding, ValidationErrors errors) {
        ValueModel source = binding.getSource();
        this.setContextIfApplicable(object, source);
        ValueModel target = binding.getTarget();
        Object value = target.getValue();
        ConvertBackConverter converter = binding.getConverter() instanceof TwoWayConverter ? new ConvertBackConverter((TwoWayConverter)binding.getConverter()) : this.getConverterNullSafe(target.getType(), source.getType());
        Object convertedValue = converter.convert(value);
        source.setValue(convertedValue);
    }

    private void setContextIfApplicable(T object, ValueModel<?> valueModel) {
        if (valueModel instanceof ContextDependentValueModel) {
            ((ContextDependentValueModel)valueModel).setContext(object);
        }
    }

    private Converter getConverterNullSafe(Class<?> source, Class<?> target) {
        Object converter = null;
        converter = target.isAssignableFrom(source) ? EmptyConverter.instance() : this.converterRegistry.getConverter(source, target);
        Assert.checkNotNull((Object)converter, (String)("No converter from type '" + source + "' to type '" + target + "'."), (Object[])new Object[0]);
        return converter;
    }
}

