/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.provider.ehcache;

import java.beans.PropertyEditor;
import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.springframework.util.ObjectUtils;
import org.springmodules.cache.CacheException;
import org.springmodules.cache.CachingModel;
import org.springmodules.cache.FatalCacheException;
import org.springmodules.cache.FlushingModel;
import org.springmodules.cache.provider.AbstractCacheProviderFacade;
import org.springmodules.cache.provider.CacheAccessException;
import org.springmodules.cache.provider.CacheModelValidator;
import org.springmodules.cache.provider.CacheNotFoundException;
import org.springmodules.cache.provider.ReflectionCacheModelEditor;
import org.springmodules.cache.provider.ehcache.EhCacheCachingModel;
import org.springmodules.cache.provider.ehcache.EhCacheFlushingModel;
import org.springmodules.cache.provider.ehcache.EhCacheModelValidator;

public final class EhCacheFacade
extends AbstractCacheProviderFacade {
    private CacheManager cacheManager;
    private CacheModelValidator cacheModelValidator = new EhCacheModelValidator();
    static /* synthetic */ Class class$org$springmodules$cache$provider$ehcache$EhCacheCachingModel;
    static /* synthetic */ Class class$org$springmodules$cache$provider$ehcache$EhCacheFlushingModel;

    public CacheModelValidator modelValidator() {
        return this.cacheModelValidator;
    }

    public PropertyEditor getCachingModelEditor() {
        ReflectionCacheModelEditor editor = new ReflectionCacheModelEditor();
        editor.setCacheModelClass(class$org$springmodules$cache$provider$ehcache$EhCacheCachingModel == null ? (class$org$springmodules$cache$provider$ehcache$EhCacheCachingModel = EhCacheFacade.class$("org.springmodules.cache.provider.ehcache.EhCacheCachingModel")) : class$org$springmodules$cache$provider$ehcache$EhCacheCachingModel);
        return editor;
    }

    public PropertyEditor getFlushingModelEditor() {
        ReflectionCacheModelEditor editor = new ReflectionCacheModelEditor();
        editor.setCacheModelClass(class$org$springmodules$cache$provider$ehcache$EhCacheFlushingModel == null ? (class$org$springmodules$cache$provider$ehcache$EhCacheFlushingModel = EhCacheFacade.class$("org.springmodules.cache.provider.ehcache.EhCacheFlushingModel")) : class$org$springmodules$cache$provider$ehcache$EhCacheFlushingModel);
        return editor;
    }

    public void setCacheManager(CacheManager newCacheManager) {
        this.cacheManager = newCacheManager;
    }

    protected Cache getCache(CachingModel model) throws CacheNotFoundException, CacheAccessException {
        EhCacheCachingModel ehCacheCachingModel = (EhCacheCachingModel)model;
        String cacheName = ehCacheCachingModel.getCacheName();
        return this.getCache(cacheName);
    }

    protected Cache getCache(String name) throws CacheNotFoundException, CacheAccessException {
        Cache cache = null;
        try {
            if (this.cacheManager.cacheExists(name)) {
                cache = this.cacheManager.getCache(name);
            }
        }
        catch (Exception exception) {
            throw new CacheAccessException(exception);
        }
        if (cache == null) {
            throw new CacheNotFoundException(name);
        }
        return cache;
    }

    protected boolean isSerializableCacheElementRequired() {
        return true;
    }

    protected void onFlushCache(FlushingModel model) throws CacheException {
        EhCacheFlushingModel flushingModel = (EhCacheFlushingModel)model;
        Object[] cacheNames = flushingModel.getCacheNames();
        if (!ObjectUtils.isEmpty((Object[])cacheNames)) {
            CacheException cacheException = null;
            int nameCount = cacheNames.length;
            try {
                for (int i = 0; i < nameCount; ++i) {
                    Cache cache = this.getCache((String)cacheNames[i]);
                    cache.removeAll();
                }
            }
            catch (CacheException exception) {
                cacheException = exception;
            }
            catch (Exception exception) {
                cacheException = new CacheAccessException(exception);
            }
            if (cacheException != null) {
                throw cacheException;
            }
        }
    }

    protected Object onGetFromCache(Serializable key, CachingModel model) throws CacheException {
        Cache cache = this.getCache(model);
        Serializable cachedObject = null;
        try {
            Element cacheElement = cache.get(key);
            if (cacheElement != null) {
                cachedObject = cacheElement.getValue();
            }
        }
        catch (Exception exception) {
            throw new CacheAccessException(exception);
        }
        return cachedObject;
    }

    protected void onPutInCache(Serializable key, CachingModel model, Object obj) throws CacheException {
        Cache cache = this.getCache(model);
        Element newCacheElement = new Element(key, (Serializable)obj);
        try {
            cache.put(newCacheElement);
        }
        catch (Exception exception) {
            throw new CacheAccessException(exception);
        }
    }

    protected void onRemoveFromCache(Serializable key, CachingModel model) throws CacheException {
        Cache cache = this.getCache(model);
        try {
            cache.remove(key);
        }
        catch (Exception exception) {
            throw new CacheAccessException(exception);
        }
    }

    protected void validateCacheManager() throws FatalCacheException {
        this.assertCacheManagerIsNotNull(this.cacheManager);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

