/*
 * Copyright 2007 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.ws.client;

import javax.xml.transform.TransformerException;

/**
 * Exception thrown whenever a transformation error occurs <i>on the client-side</i>.
 *
 * @author Arjen Poutsma
 * @since 1.0.0
 */
public class WebServiceTransformerException extends WebServiceClientException {

    /**
     * Create a new instance of the <code>WebServiceTransformerException</code> class.
     *
     * @param msg the detail message
     */
    public WebServiceTransformerException(String msg) {
        super(msg);
    }

    /**
     * Create a new instance of the <code>WebServiceTransformerException</code> class.
     *
     * @param msg the detail message
     * @param ex  the root {@link Throwable exception}
     */
    public WebServiceTransformerException(String msg, TransformerException ex) {
        super(msg, ex);
    }

}
