/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.axiom.support;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.xml.namespace.QNameUtils;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public abstract class AxiomUtils {
    public static OMNamespace toNamespace(QName qName, OMElement resolveElement) throws OMException {
        String prefix = QNameUtils.getPrefix(qName);
        if (StringUtils.hasLength((String)qName.getNamespaceURI()) && StringUtils.hasLength((String)prefix)) {
            return resolveElement.declareNamespace(qName.getNamespaceURI(), prefix);
        }
        if (StringUtils.hasLength((String)qName.getNamespaceURI())) {
            return resolveElement.declareNamespace(qName.getNamespaceURI(), "");
        }
        throw new IllegalArgumentException("qName [" + qName + "] does not contain a namespace");
    }

    public static String toLanguage(Locale locale) {
        return locale.toString().replace('_', '-');
    }

    public static Locale toLocale(String language) {
        language = language.replace('-', '_');
        return StringUtils.parseLocaleString((String)language);
    }

    public static void removeContents(OMContainer container) {
        Iterator iterator = container.getChildren();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public static Document toDocument(SOAPEnvelope envelope) {
        try {
            if (envelope instanceof Element) {
                return ((Element)envelope).getOwnerDocument();
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            envelope.build();
            envelope.serialize((OutputStream)bos);
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            return documentBuilderFactory.newDocumentBuilder().parse(bis);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Error in converting SOAP Envelope to Document", ex);
        }
    }

    public static SOAPEnvelope toEnvelope(Document document) {
        try {
            DOMImplementation implementation = document.getImplementation();
            Assert.isInstanceOf(DOMImplementationLS.class, (Object)implementation);
            DOMImplementationLS loadSaveImplementation = (DOMImplementationLS)((Object)implementation);
            LSOutput output = loadSaveImplementation.createLSOutput();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            output.setByteStream(bos);
            LSSerializer serializer = loadSaveImplementation.createLSSerializer();
            serializer.write(document, output);
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            StAXSOAPModelBuilder stAXSOAPModelBuilder = new StAXSOAPModelBuilder(XMLInputFactory.newInstance().createXMLStreamReader(bis), null);
            SOAPEnvelope envelope = stAXSOAPModelBuilder.getSOAPEnvelope();
            envelope.serialize((OutputStream)new NullOutputStream());
            return envelope;
        }
        catch (Exception ex) {
            IllegalArgumentException iaex = new IllegalArgumentException("Error in converting Document to SOAP Envelope");
            iaex.initCause(ex);
            throw iaex;
        }
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        public void write(int b) throws IOException {
        }

        public void write(byte[] b) throws IOException {
        }

        public void write(byte[] b, int off, int len) throws IOException {
        }
    }
}

