/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.addressing.core;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.springframework.util.Assert;

public final class EndpointReference {
    private final URI address;
    private final List referenceProperties;
    private final List referenceParameters;

    public EndpointReference(URI address) {
        Assert.notNull((Object)address, (String)"address must not be null");
        this.address = address;
        this.referenceParameters = Collections.EMPTY_LIST;
        this.referenceProperties = Collections.EMPTY_LIST;
    }

    public EndpointReference(URI address, List referenceProperties, List referenceParameters) {
        Assert.notNull((Object)address, (String)"address must not be null");
        Assert.notNull((Object)referenceProperties, (String)"referenceProperties must not be null");
        Assert.notNull((Object)referenceParameters, (String)"referenceParameters must not be null");
        this.address = address;
        this.referenceProperties = referenceProperties;
        this.referenceParameters = referenceParameters;
    }

    public URI getAddress() {
        return this.address;
    }

    public List getReferenceProperties() {
        return this.referenceProperties;
    }

    public List getReferenceParameters() {
        return this.referenceParameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o instanceof EndpointReference) {
            EndpointReference other = (EndpointReference)o;
            return this.address.equals(other.address);
        }
        return false;
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public String toString() {
        return this.address.toString();
    }
}

