/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.addressing.server;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.ws.soap.addressing.server.AbstractActionEndpointMapping;

public class SimpleActionEndpointMapping
extends AbstractActionEndpointMapping {
    private final Map actionMap = new HashMap();
    private URI address;

    public void setMappings(Properties mappings) throws URISyntaxException {
        this.setActionMap(mappings);
    }

    public void setActionMap(Map actionMap) throws URISyntaxException {
        Iterator it = actionMap.entrySet().iterator();
        while (it.hasNext()) {
            URI action;
            Map.Entry entry = it.next();
            if (entry.getKey() instanceof String) {
                action = new URI((String)entry.getKey());
            } else if (entry.getKey() instanceof URI) {
                action = (URI)entry.getKey();
            } else {
                throw new IllegalArgumentException("Invalid key [" + entry.getKey() + "]; expected String or URI");
            }
            this.actionMap.put(action, entry.getValue());
        }
    }

    public void setAddress(URI address) {
        this.address = address;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.registerEndpoints(this.actionMap);
    }

    protected void registerEndpoints(Map actionMap) throws BeansException {
        if (actionMap.isEmpty()) {
            this.logger.warn((Object)"Neither 'actionMap' nor 'mappings' set on SimpleActionEndpointMapping");
        } else {
            Iterator iterator = actionMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                URI action = (URI)entry.getKey();
                Object endpoint = entry.getValue();
                if (endpoint instanceof String) {
                    endpoint = ((String)endpoint).trim();
                }
                this.registerEndpoint(action, endpoint);
            }
        }
    }

    protected URI getEndpointAddress(Object endpoint) {
        return this.address;
    }
}

