/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.xwss.callback;

import com.sun.xml.wss.impl.callback.CertificateValidationCallback;
import com.sun.xml.wss.impl.callback.DecryptionKeyCallback;
import com.sun.xml.wss.impl.callback.EncryptionKeyCallback;
import com.sun.xml.wss.impl.callback.SignatureKeyCallback;
import com.sun.xml.wss.impl.callback.SignatureVerificationKeyCallback;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.springframework.ws.soap.security.callback.AbstractCallbackHandler;

public class CryptographyCallbackHandler
extends AbstractCallbackHandler {
    protected final void handleInternal(Callback callback) throws IOException, UnsupportedCallbackException {
        if (callback instanceof CertificateValidationCallback) {
            this.handleCertificateValidationCallback((CertificateValidationCallback)callback);
        } else if (callback instanceof DecryptionKeyCallback) {
            this.handleDecryptionKeyCallback((DecryptionKeyCallback)callback);
        } else if (callback instanceof EncryptionKeyCallback) {
            this.handleEncryptionKeyCallback((EncryptionKeyCallback)callback);
        } else if (callback instanceof SignatureKeyCallback) {
            this.handleSignatureKeyCallback((SignatureKeyCallback)callback);
        } else if (callback instanceof SignatureVerificationKeyCallback) {
            this.handleSignatureVerificationKeyCallback((SignatureVerificationKeyCallback)callback);
        } else {
            throw new UnsupportedCallbackException(callback);
        }
    }

    protected void handleCertificateValidationCallback(CertificateValidationCallback callback) throws IOException, UnsupportedCallbackException {
        throw new UnsupportedCallbackException((Callback)callback);
    }

    protected final void handleDecryptionKeyCallback(DecryptionKeyCallback callback) throws IOException, UnsupportedCallbackException {
        if (callback.getRequest() instanceof DecryptionKeyCallback.PrivateKeyRequest) {
            this.handlePrivateKeyRequest(callback, (DecryptionKeyCallback.PrivateKeyRequest)callback.getRequest());
        } else if (callback.getRequest() instanceof DecryptionKeyCallback.SymmetricKeyRequest) {
            this.handleSymmetricKeyRequest(callback, (DecryptionKeyCallback.SymmetricKeyRequest)callback.getRequest());
        } else {
            throw new UnsupportedCallbackException((Callback)callback);
        }
    }

    protected final void handlePrivateKeyRequest(DecryptionKeyCallback callback, DecryptionKeyCallback.PrivateKeyRequest request) throws IOException, UnsupportedCallbackException {
        if (request instanceof DecryptionKeyCallback.PublicKeyBasedPrivKeyRequest) {
            this.handlePublicKeyBasedPrivKeyRequest(callback, (DecryptionKeyCallback.PublicKeyBasedPrivKeyRequest)request);
        } else if (request instanceof DecryptionKeyCallback.X509CertificateBasedRequest) {
            this.handleX509CertificateBasedRequest(callback, (DecryptionKeyCallback.X509CertificateBasedRequest)request);
        } else if (request instanceof DecryptionKeyCallback.X509IssuerSerialBasedRequest) {
            this.handleX509IssuerSerialBasedRequest(callback, (DecryptionKeyCallback.X509IssuerSerialBasedRequest)request);
        } else if (request instanceof DecryptionKeyCallback.X509SubjectKeyIdentifierBasedRequest) {
            this.handleX509SubjectKeyIdentifierBasedRequest(callback, (DecryptionKeyCallback.X509SubjectKeyIdentifierBasedRequest)request);
        } else {
            throw new UnsupportedCallbackException((Callback)callback);
        }
    }

    protected void handlePublicKeyBasedPrivKeyRequest(DecryptionKeyCallback callback, DecryptionKeyCallback.PublicKeyBasedPrivKeyRequest request) throws IOException, UnsupportedCallbackException {
        throw new UnsupportedCallbackException((Callback)callback);
    }

    protected void handleX509CertificateBasedRequest(DecryptionKeyCallback callback, DecryptionKeyCallback.X509CertificateBasedRequest request) throws IOException, UnsupportedCallbackException {
        throw new UnsupportedCallbackException((Callback)callback);
    }

    protected void handleX509IssuerSerialBasedRequest(DecryptionKeyCallback callback, DecryptionKeyCallback.X509IssuerSerialBasedRequest request) throws IOException, UnsupportedCallbackException {
        throw new UnsupportedCallbackException((Callback)callback);
    }

    protected void handleX509SubjectKeyIdentifierBasedRequest(DecryptionKeyCallback callback, DecryptionKeyCallback.X509SubjectKeyIdentifierBasedRequest request) throws IOException, UnsupportedCallbackException {
        throw new UnsupportedCallbackException((Callback)callback);
    }

    protected final void handleSymmetricKeyRequest(DecryptionKeyCallback callback, DecryptionKeyCallback.SymmetricKeyRequest request) throws IOException, UnsupportedCallbackException {
        if (!(request instanceof DecryptionKeyCallback.AliasSymmetricKeyRequest)) {
            throw new UnsupportedCallbackException((Callback)callback);
        }
        DecryptionKeyCallback.AliasSymmetricKeyRequest aliasSymmetricKeyRequest = (DecryptionKeyCallback.AliasSymmetricKeyRequest)request;
        this.handleAliasSymmetricKeyRequest(callback, aliasSymmetricKeyRequest);
    }

    protected void handleAliasSymmetricKeyRequest(DecryptionKeyCallback callback, DecryptionKeyCallback.AliasSymmetricKeyRequest request) throws IOException, UnsupportedCallbackException {
        throw new UnsupportedCallbackException((Callback)callback);
    }

    protected final void handleEncryptionKeyCallback(EncryptionKeyCallback callback) throws IOException, UnsupportedCallbackException {
        if (callback.getRequest() instanceof EncryptionKeyCallback.SymmetricKeyRequest) {
            this.handleSymmetricKeyRequest(callback, (EncryptionKeyCallback.SymmetricKeyRequest)callback.getRequest());
        } else if (callback.getRequest() instanceof EncryptionKeyCallback.X509CertificateRequest) {
            this.handleX509CertificateRequest(callback, (EncryptionKeyCallback.X509CertificateRequest)callback.getRequest());
        } else {
            throw new UnsupportedCallbackException((Callback)callback);
        }
    }

    protected final void handleSymmetricKeyRequest(EncryptionKeyCallback callback, EncryptionKeyCallback.SymmetricKeyRequest request) throws IOException, UnsupportedCallbackException {
        if (request instanceof EncryptionKeyCallback.AliasSymmetricKeyRequest) {
            this.handleAliasSymmetricKeyRequest(callback, (EncryptionKeyCallback.AliasSymmetricKeyRequest)request);
        }
    }

    protected void handleAliasSymmetricKeyRequest(EncryptionKeyCallback callback, EncryptionKeyCallback.AliasSymmetricKeyRequest request) throws IOException, UnsupportedCallbackException {
        throw new UnsupportedCallbackException((Callback)callback);
    }

    protected final void handleX509CertificateRequest(EncryptionKeyCallback callback, EncryptionKeyCallback.X509CertificateRequest request) throws IOException, UnsupportedCallbackException {
        if (request instanceof EncryptionKeyCallback.AliasX509CertificateRequest) {
            this.handleAliasX509CertificateRequest(callback, (EncryptionKeyCallback.AliasX509CertificateRequest)request);
        } else if (request instanceof EncryptionKeyCallback.DefaultX509CertificateRequest) {
            this.handleDefaultX509CertificateRequest(callback, (EncryptionKeyCallback.DefaultX509CertificateRequest)request);
        } else if (request instanceof EncryptionKeyCallback.PublicKeyBasedRequest) {
            this.handlePublicKeyBasedRequest(callback, (EncryptionKeyCallback.PublicKeyBasedRequest)request);
        } else {
            throw new UnsupportedCallbackException((Callback)callback);
        }
    }

    protected void handleAliasX509CertificateRequest(EncryptionKeyCallback callback, EncryptionKeyCallback.AliasX509CertificateRequest request) throws IOException, UnsupportedCallbackException {
        throw new UnsupportedCallbackException((Callback)callback);
    }

    protected void handleDefaultX509CertificateRequest(EncryptionKeyCallback callback, EncryptionKeyCallback.DefaultX509CertificateRequest request) throws IOException, UnsupportedCallbackException {
        throw new UnsupportedCallbackException((Callback)callback);
    }

    protected void handlePublicKeyBasedRequest(EncryptionKeyCallback callback, EncryptionKeyCallback.PublicKeyBasedRequest request) throws IOException, UnsupportedCallbackException {
        throw new UnsupportedCallbackException((Callback)callback);
    }

    protected final void handleSignatureKeyCallback(SignatureKeyCallback callback) throws IOException, UnsupportedCallbackException {
        if (!(callback.getRequest() instanceof SignatureKeyCallback.PrivKeyCertRequest)) {
            throw new UnsupportedCallbackException((Callback)callback);
        }
        this.handlePrivKeyCertRequest(callback, (SignatureKeyCallback.PrivKeyCertRequest)callback.getRequest());
    }

    protected final void handlePrivKeyCertRequest(SignatureKeyCallback cb, SignatureKeyCallback.PrivKeyCertRequest request) throws IOException, UnsupportedCallbackException {
        if (request instanceof SignatureKeyCallback.DefaultPrivKeyCertRequest) {
            this.handleDefaultPrivKeyCertRequest(cb, (SignatureKeyCallback.DefaultPrivKeyCertRequest)request);
        } else if (cb.getRequest() instanceof SignatureKeyCallback.AliasPrivKeyCertRequest) {
            this.handleAliasPrivKeyCertRequest(cb, (SignatureKeyCallback.AliasPrivKeyCertRequest)request);
        } else if (cb.getRequest() instanceof SignatureKeyCallback.PublicKeyBasedPrivKeyCertRequest) {
            this.handlePublicKeyBasedPrivKeyCertRequest(cb, (SignatureKeyCallback.PublicKeyBasedPrivKeyCertRequest)request);
        } else {
            throw new UnsupportedCallbackException((Callback)cb);
        }
    }

    protected void handleDefaultPrivKeyCertRequest(SignatureKeyCallback callback, SignatureKeyCallback.DefaultPrivKeyCertRequest request) throws IOException, UnsupportedCallbackException {
        throw new UnsupportedCallbackException((Callback)callback);
    }

    protected void handleAliasPrivKeyCertRequest(SignatureKeyCallback callback, SignatureKeyCallback.AliasPrivKeyCertRequest request) throws IOException, UnsupportedCallbackException {
        throw new UnsupportedCallbackException((Callback)callback);
    }

    protected void handlePublicKeyBasedPrivKeyCertRequest(SignatureKeyCallback callback, SignatureKeyCallback.PublicKeyBasedPrivKeyCertRequest request) throws IOException, UnsupportedCallbackException {
        throw new UnsupportedCallbackException((Callback)callback);
    }

    protected final void handleSignatureVerificationKeyCallback(SignatureVerificationKeyCallback callback) throws UnsupportedCallbackException, IOException {
        if (!(callback.getRequest() instanceof SignatureVerificationKeyCallback.X509CertificateRequest)) {
            throw new UnsupportedCallbackException((Callback)callback);
        }
        this.handleX509CertificateRequest(callback, (SignatureVerificationKeyCallback.X509CertificateRequest)callback.getRequest());
    }

    protected final void handleX509CertificateRequest(SignatureVerificationKeyCallback callback, SignatureVerificationKeyCallback.X509CertificateRequest request) throws UnsupportedCallbackException, IOException {
        if (request instanceof SignatureVerificationKeyCallback.PublicKeyBasedRequest) {
            this.handlePublicKeyBasedRequest(callback, (SignatureVerificationKeyCallback.PublicKeyBasedRequest)request);
        } else if (request instanceof SignatureVerificationKeyCallback.X509IssuerSerialBasedRequest) {
            this.handleX509IssuerSerialBasedRequest(callback, (SignatureVerificationKeyCallback.X509IssuerSerialBasedRequest)request);
        } else if (request instanceof SignatureVerificationKeyCallback.X509SubjectKeyIdentifierBasedRequest) {
            this.handleX509SubjectKeyIdentifierBasedRequest(callback, (SignatureVerificationKeyCallback.X509SubjectKeyIdentifierBasedRequest)request);
        } else {
            throw new UnsupportedCallbackException((Callback)callback);
        }
    }

    protected void handleX509SubjectKeyIdentifierBasedRequest(SignatureVerificationKeyCallback callback, SignatureVerificationKeyCallback.X509SubjectKeyIdentifierBasedRequest request) throws IOException, UnsupportedCallbackException {
        throw new UnsupportedCallbackException((Callback)callback);
    }

    protected void handleX509IssuerSerialBasedRequest(SignatureVerificationKeyCallback callback, SignatureVerificationKeyCallback.X509IssuerSerialBasedRequest request) throws IOException, UnsupportedCallbackException {
        throw new UnsupportedCallbackException((Callback)callback);
    }

    protected void handlePublicKeyBasedRequest(SignatureVerificationKeyCallback callback, SignatureVerificationKeyCallback.PublicKeyBasedRequest request) throws IOException, UnsupportedCallbackException {
        throw new UnsupportedCallbackException((Callback)callback);
    }
}

