/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.jaxb;

import java.util.Iterator;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.ValidationEventHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.XmlMappingException;
import org.springframework.oxm.jaxb.JaxbUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractJaxbMarshaller
implements Marshaller,
Unmarshaller,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String contextPath;
    private Map marshallerProperties;
    private Map unmarshallerProperties;
    private JAXBContext jaxbContext;
    private ValidationEventHandler validationEventHandler;

    protected String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        Assert.notNull((Object)contextPath, (String)"'contextPath' must not be null");
        this.contextPath = contextPath;
    }

    public void setContextPaths(String[] contextPaths) {
        Assert.notEmpty((Object[])contextPaths, (String)"'contextPaths' must not be empty");
        this.contextPath = StringUtils.arrayToDelimitedString((Object[])contextPaths, (String)":");
    }

    public void setMarshallerProperties(Map properties) {
        this.marshallerProperties = properties;
    }

    public void setUnmarshallerProperties(Map properties) {
        this.unmarshallerProperties = properties;
    }

    public void setValidationEventHandler(ValidationEventHandler validationEventHandler) {
        this.validationEventHandler = validationEventHandler;
    }

    public JAXBContext getJaxbContext() {
        return this.jaxbContext;
    }

    public final void afterPropertiesSet() throws Exception {
        try {
            this.jaxbContext = this.createJaxbContext();
        }
        catch (JAXBException ex) {
            throw this.convertJaxbException(ex);
        }
    }

    protected XmlMappingException convertJaxbException(JAXBException ex) {
        return JaxbUtils.convertJaxbException(ex);
    }

    protected javax.xml.bind.Marshaller createMarshaller() {
        try {
            javax.xml.bind.Marshaller marshaller = this.jaxbContext.createMarshaller();
            if (this.marshallerProperties != null) {
                Iterator iterator = this.marshallerProperties.keySet().iterator();
                while (iterator.hasNext()) {
                    String name = (String)iterator.next();
                    marshaller.setProperty(name, this.marshallerProperties.get(name));
                }
            }
            if (this.validationEventHandler != null) {
                marshaller.setEventHandler(this.validationEventHandler);
            }
            this.initJaxbMarshaller(marshaller);
            return marshaller;
        }
        catch (JAXBException ex) {
            throw this.convertJaxbException(ex);
        }
    }

    protected javax.xml.bind.Unmarshaller createUnmarshaller() {
        try {
            javax.xml.bind.Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            if (this.unmarshallerProperties != null) {
                Iterator iterator = this.unmarshallerProperties.keySet().iterator();
                while (iterator.hasNext()) {
                    String name = (String)iterator.next();
                    unmarshaller.setProperty(name, this.unmarshallerProperties.get(name));
                }
            }
            if (this.validationEventHandler != null) {
                unmarshaller.setEventHandler(this.validationEventHandler);
            }
            this.initJaxbUnmarshaller(unmarshaller);
            return unmarshaller;
        }
        catch (JAXBException ex) {
            throw this.convertJaxbException(ex);
        }
    }

    protected void initJaxbMarshaller(javax.xml.bind.Marshaller marshaller) throws JAXBException {
    }

    protected void initJaxbUnmarshaller(javax.xml.bind.Unmarshaller unmarshaller) throws JAXBException {
    }

    protected abstract JAXBContext createJaxbContext() throws Exception;
}

