/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.castor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.util.XMLEventConsumer;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ResolverException;
import org.exolab.castor.xml.UnmarshalHandler;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.XMLContext;
import org.exolab.castor.xml.XMLException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.oxm.AbstractMarshaller;
import org.springframework.oxm.XmlMappingException;
import org.springframework.oxm.castor.CastorSystemException;
import org.springframework.oxm.castor.CastorUnmarshallingFailureException;
import org.springframework.oxm.castor.CastorUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.xml.dom.DomContentHandler;
import org.springframework.xml.sax.SaxUtils;
import org.springframework.xml.stream.StaxEventContentHandler;
import org.springframework.xml.stream.StaxEventXmlReader;
import org.springframework.xml.stream.StaxStreamContentHandler;
import org.springframework.xml.stream.StaxStreamXmlReader;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class CastorMarshaller
extends AbstractMarshaller
implements InitializingBean {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private Resource[] mappingLocations;
    private String encoding = "UTF-8";
    private Class targetClass;
    private XMLContext xmlContext;
    private boolean validating = false;
    private boolean whitespacePreserve = false;
    private boolean ignoreExtraAttributes = true;
    private boolean ignoreExtraElements = false;
    private Properties namespaceMappings;
    private boolean suppressNamespaces = false;
    private boolean suppressXsiType = false;

    public boolean getIgnoreExtraAttributes() {
        return this.ignoreExtraAttributes;
    }

    public void setIgnoreExtraAttributes(boolean ignoreExtraAttributes) {
        this.ignoreExtraAttributes = ignoreExtraAttributes;
    }

    public boolean getIgnoreExtraElements() {
        return this.ignoreExtraElements;
    }

    public void setIgnoreExtraElements(boolean ignoreExtraElements) {
        this.ignoreExtraElements = ignoreExtraElements;
    }

    public boolean getWhitespacePreserve() {
        return this.whitespacePreserve;
    }

    public void setWhitespacePreserve(boolean whitespacePreserve) {
        this.whitespacePreserve = whitespacePreserve;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public Properties getNamespaceMappings() {
        return this.namespaceMappings;
    }

    public void setNamespaceMappings(Properties namespaceMappings) {
        this.namespaceMappings = namespaceMappings;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setMappingLocation(Resource mappingLocation) {
        this.mappingLocations = new Resource[]{mappingLocation};
    }

    public void setMappingLocations(Resource[] mappingLocations) {
        this.mappingLocations = mappingLocations;
    }

    public boolean isSuppressNamespaces() {
        return this.suppressNamespaces;
    }

    public void setSuppressNamespaces(boolean suppressNamespaces) {
        this.suppressNamespaces = suppressNamespaces;
    }

    public boolean isSuppressXsiType() {
        return this.suppressXsiType;
    }

    public void setSuppressXsiType(boolean suppressXsiType) {
        this.suppressXsiType = suppressXsiType;
    }

    public void setTargetClass(Class targetClass) {
        this.targetClass = targetClass;
    }

    public final void afterPropertiesSet() throws IOException {
        if (this.mappingLocations != null && this.targetClass != null) {
            throw new IllegalArgumentException("Cannot set both the 'mappingLocations' and 'targetClass' property. Set targetClass for unmarshalling a single class, and 'mappingLocations' for multiple classes'");
        }
        if (this.logger.isInfoEnabled()) {
            if (this.mappingLocations != null) {
                this.logger.info((Object)("Configured using " + StringUtils.arrayToCommaDelimitedString((Object[])this.mappingLocations)));
            } else if (this.targetClass != null) {
                this.logger.info((Object)("Configured for target class [" + this.targetClass.getName() + "]"));
            } else {
                this.logger.info((Object)"Using default configuration");
            }
        }
        try {
            this.xmlContext = this.createXMLContext(this.mappingLocations, this.targetClass);
        }
        catch (MappingException ex) {
            throw new CastorSystemException("Could not load Castor mapping: " + ex.getMessage(), ex);
        }
        catch (ResolverException rex) {
            throw new CastorSystemException("Could not load Castor mapping: " + rex.getMessage(), rex);
        }
    }

    public boolean supports(Class clazz) {
        return true;
    }

    protected XMLContext createXMLContext(Resource[] mappingLocations, Class targetClass) throws MappingException, IOException, ResolverException {
        XMLContext context = new XMLContext();
        if (!ObjectUtils.isEmpty((Object[])mappingLocations)) {
            Mapping mapping = new Mapping();
            for (int i = 0; i < mappingLocations.length; ++i) {
                mapping.loadMapping(SaxUtils.createInputSource((Resource)mappingLocations[i]));
            }
            context.addMapping(mapping);
        }
        if (targetClass != null) {
            context.addClass(targetClass);
        }
        return context;
    }

    protected final void marshalDomNode(Object graph, Node node) throws XmlMappingException {
        this.marshalSaxHandlers(graph, (ContentHandler)new DomContentHandler(node), null);
    }

    protected final void marshalSaxHandlers(Object graph, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws XmlMappingException {
        Marshaller marshaller = this.xmlContext.createMarshaller();
        marshaller.setContentHandler(contentHandler);
        this.marshal(graph, marshaller);
    }

    protected final void marshalOutputStream(Object graph, OutputStream outputStream) throws XmlMappingException, IOException {
        this.marshalWriter(graph, new OutputStreamWriter(outputStream, this.encoding));
    }

    protected final void marshalWriter(Object graph, Writer writer) throws XmlMappingException, IOException {
        Marshaller marshaller = this.xmlContext.createMarshaller();
        marshaller.setWriter(writer);
        this.marshal(graph, marshaller);
    }

    protected final void marshalXmlEventWriter(Object graph, XMLEventWriter eventWriter) throws XmlMappingException {
        this.marshalSaxHandlers(graph, (ContentHandler)new StaxEventContentHandler((XMLEventConsumer)eventWriter), null);
    }

    protected final void marshalXmlStreamWriter(Object graph, XMLStreamWriter streamWriter) throws XmlMappingException {
        this.marshalSaxHandlers(graph, (ContentHandler)new StaxStreamContentHandler(streamWriter), null);
    }

    private void marshal(Object graph, Marshaller marshaller) {
        try {
            this.customizeMarshaller(marshaller);
            marshaller.marshal(graph);
        }
        catch (XMLException ex) {
            throw this.convertCastorException(ex, true);
        }
    }

    protected void customizeMarshaller(Marshaller marshaller) {
        marshaller.setValidation(this.isValidating());
        marshaller.setSuppressNamespaces(this.isSuppressNamespaces());
        marshaller.setSuppressXSIType(this.isSuppressXsiType());
        Properties namespaceMappings = this.getNamespaceMappings();
        if (namespaceMappings != null) {
            Iterator<Object> iterator = namespaceMappings.keySet().iterator();
            while (iterator.hasNext()) {
                String prefix = (String)iterator.next();
                String uri = namespaceMappings.getProperty(prefix);
                marshaller.setNamespaceMapping(prefix, uri);
            }
        }
    }

    protected final Object unmarshalDomNode(Node node) throws XmlMappingException {
        try {
            return this.createUnmarshaller().unmarshal(node);
        }
        catch (XMLException ex) {
            throw this.convertCastorException(ex, false);
        }
    }

    protected final Object unmarshalInputStream(InputStream inputStream) throws XmlMappingException, IOException {
        try {
            return this.createUnmarshaller().unmarshal(new InputSource(inputStream));
        }
        catch (XMLException ex) {
            throw this.convertCastorException(ex, false);
        }
    }

    protected final Object unmarshalReader(Reader reader) throws XmlMappingException, IOException {
        try {
            return this.createUnmarshaller().unmarshal(new InputSource(reader));
        }
        catch (XMLException ex) {
            throw this.convertCastorException(ex, false);
        }
    }

    protected final Object unmarshalXmlEventReader(XMLEventReader eventReader) {
        StaxEventXmlReader reader = new StaxEventXmlReader(eventReader);
        try {
            return this.unmarshalSaxReader((XMLReader)reader, new InputSource());
        }
        catch (IOException ex) {
            throw new CastorUnmarshallingFailureException(new MarshalException((Throwable)ex));
        }
    }

    protected final Object unmarshalSaxReader(XMLReader xmlReader, InputSource inputSource) throws XmlMappingException, IOException {
        UnmarshalHandler unmarshalHandler = this.createUnmarshaller().createHandler();
        try {
            ContentHandler contentHandler = Unmarshaller.getContentHandler((UnmarshalHandler)unmarshalHandler);
            xmlReader.setContentHandler(contentHandler);
            xmlReader.parse(inputSource);
            return unmarshalHandler.getObject();
        }
        catch (SAXException ex) {
            throw new CastorUnmarshallingFailureException(ex);
        }
    }

    protected final Object unmarshalXmlStreamReader(XMLStreamReader streamReader) {
        StaxStreamXmlReader reader = new StaxStreamXmlReader(streamReader);
        try {
            return this.unmarshalSaxReader((XMLReader)reader, new InputSource());
        }
        catch (IOException ex) {
            throw new CastorUnmarshallingFailureException(new MarshalException((Throwable)ex));
        }
    }

    private Unmarshaller createUnmarshaller() {
        Unmarshaller unmarshaller = this.xmlContext.createUnmarshaller();
        if (this.targetClass != null) {
            unmarshaller.setClass(this.targetClass);
            unmarshaller.setClassLoader(this.targetClass.getClassLoader());
        }
        this.customizeUnmarshaller(unmarshaller);
        return unmarshaller;
    }

    protected void customizeUnmarshaller(Unmarshaller unmarshaller) {
        unmarshaller.setValidation(this.isValidating());
        unmarshaller.setWhitespacePreserve(this.getWhitespacePreserve());
        unmarshaller.setIgnoreExtraAttributes(this.getIgnoreExtraAttributes());
        unmarshaller.setIgnoreExtraElements(this.getIgnoreExtraElements());
    }

    public XmlMappingException convertCastorException(XMLException ex, boolean marshalling) {
        return CastorUtils.convertXmlException(ex, marshalling);
    }
}

