/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import jakarta.faces.FacesException;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseId;
import jakarta.faces.lifecycle.Lifecycle;
import jakarta.faces.lifecycle.LifecycleFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.faces.support.LifecycleWrapper;
import org.springframework.faces.webflow.JsfUtils;

public class FlowLifecycle
extends LifecycleWrapper {
    private static final Log logger = LogFactory.getLog(FlowLifecycle.class);
    private final Lifecycle wrapped;

    public static Lifecycle newInstance() {
        LifecycleFactory lifecycleFactory = JsfUtils.findFactory(LifecycleFactory.class);
        Lifecycle defaultLifecycle = lifecycleFactory.getLifecycle("DEFAULT");
        return new FlowLifecycle(defaultLifecycle);
    }

    FlowLifecycle(Lifecycle wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public Lifecycle getWrapped() {
        return this.wrapped;
    }

    @Override
    public void execute(FacesContext context) throws FacesException {
        logger.debug((Object)"Executing view post back lifecycle");
        for (int p = PhaseId.APPLY_REQUEST_VALUES.getOrdinal(); p <= PhaseId.INVOKE_APPLICATION.getOrdinal(); ++p) {
            PhaseId phaseId = (PhaseId)PhaseId.VALUES.get(p);
            if (this.skipPhase(context, phaseId)) continue;
            context.setCurrentPhaseId(phaseId);
            this.invokePhase(context, phaseId);
        }
    }

    private boolean skipPhase(FacesContext context, PhaseId phaseId) {
        if (context.getResponseComplete()) {
            return true;
        }
        return context.getRenderResponse();
    }

    private void invokePhase(FacesContext context, PhaseId phaseId) {
        JsfUtils.notifyBeforeListeners(phaseId, this, context);
        if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
            logger.debug((Object)"Processing decodes");
            context.getViewRoot().processDecodes(context);
        } else if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
            logger.debug((Object)"Processing validators");
            context.getViewRoot().processValidators(context);
        } else if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
            logger.debug((Object)"Processing model updates");
            context.getViewRoot().processUpdates(context);
        } else {
            logger.debug((Object)"Processing application");
            context.getViewRoot().processApplication(context);
        }
        JsfUtils.notifyAfterListeners(phaseId, this, context);
    }
}

