/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow.context.portlet;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.portlet.PortletRequest;
import org.springframework.binding.collection.StringKeyedMapAdapter;
import org.springframework.webflow.core.collection.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestPropertyMap
extends StringKeyedMapAdapter {
    private Boolean useArrayForMultiValueAttributes;
    private final PortletRequest portletRequest;

    public RequestPropertyMap(PortletRequest portletRequest) {
        this.portletRequest = portletRequest;
    }

    public void setUseArrayForMultiValueAttributes(Boolean useArrayForMultiValueAttributes) {
        this.useArrayForMultiValueAttributes = useArrayForMultiValueAttributes;
    }

    public Boolean useArrayForMultiValueAttributes() {
        return this.useArrayForMultiValueAttributes;
    }

    protected Object getAttribute(String key) {
        if (this.useArrayForMultiValueAttributes == null) {
            List list = Collections.list(this.portletRequest.getProperties(key));
            if (1 == list.size()) {
                return list.get(0);
            }
            return list.toArray(new String[list.size()]);
        }
        if (this.useArrayForMultiValueAttributes.booleanValue()) {
            List list = Collections.list(this.portletRequest.getProperties(key));
            return list.toArray(new String[list.size()]);
        }
        return this.portletRequest.getProperty(key);
    }

    protected void setAttribute(String key, Object value) {
        throw new UnsupportedOperationException("Cannot set PortletRequest property");
    }

    protected void removeAttribute(String key) {
        throw new UnsupportedOperationException("Cannot remove PortletRequest property");
    }

    protected Iterator<String> getAttributeNames() {
        return CollectionUtils.toIterator((Enumeration)this.portletRequest.getPropertyNames());
    }
}

