/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert.converters;

import java.lang.reflect.Array;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.converters.Converter;

public class ArrayToArray
implements Converter {
    private ConversionService conversionService;
    private ConversionExecutor elementConverter;

    public ArrayToArray(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public ArrayToArray(ConversionExecutor elementConverter) {
        this.elementConverter = elementConverter;
    }

    public Class getSourceClass() {
        return Object[].class;
    }

    public Class getTargetClass() {
        return Object[].class;
    }

    public Object convertSourceToTargetClass(Object source, Class targetClass) throws Exception {
        if (source == null) {
            return null;
        }
        Class<?> sourceComponentType = source.getClass().getComponentType();
        Class<?> targetComponentType = targetClass.getComponentType();
        int length = Array.getLength(source);
        Object targetArray = Array.newInstance(targetComponentType, length);
        ConversionExecutor converter = this.getElementConverter(sourceComponentType, targetComponentType);
        int i = 0;
        while (i < length) {
            Object value = Array.get(source, i);
            Array.set(targetArray, i, converter.execute(value));
            ++i;
        }
        return targetArray;
    }

    private ConversionExecutor getElementConverter(Class sourceComponentType, Class targetComponentType) {
        if (this.elementConverter != null) {
            return this.elementConverter;
        }
        return this.conversionService.getConversionExecutor(sourceComponentType, targetComponentType);
    }
}

