/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.spel;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.binding.expression.EvaluationException;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.PropertyNotFoundException;
import org.springframework.binding.expression.ValueCoercionException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;

public class SpringELExpression
implements Expression {
    private org.springframework.expression.Expression expression;
    private StandardEvaluationContext evaluationContext;
    private Class expectedType;
    private Map expressionVariables;

    public SpringELExpression(org.springframework.expression.Expression expression, Map expressionVariables, Class expectedType, StandardEvaluationContext evaluationContext) {
        Assert.notNull((Object)expression, (String)"The SpelExpression is required for evaluation");
        Assert.notNull((Object)evaluationContext, (String)"The StandardEvaluationContext is required for evaluation");
        this.expression = expression;
        this.expressionVariables = expressionVariables;
        this.expectedType = expectedType;
        this.evaluationContext = evaluationContext;
    }

    public String getExpressionString() {
        return this.expression.getExpressionString();
    }

    public Object getValue(Object rootObject) throws EvaluationException {
        try {
            this.updateEvaluationContext(rootObject);
            return this.expression.getValue((EvaluationContext)this.evaluationContext, this.expectedType);
        }
        catch (SpelEvaluationException e) {
            if (e.getMessageCode().equals((Object)SpelMessage.PROPERTY_OR_FIELD_NOT_READABLE)) {
                throw new PropertyNotFoundException(rootObject.getClass(), this.getExpressionString(), e);
            }
            if (e.getMessageCode().equals((Object)SpelMessage.TYPE_CONVERSION_ERROR)) {
                throw new ValueCoercionException(rootObject.getClass(), this.getExpressionString(), null, this.expectedType, e);
            }
            throw new EvaluationException(rootObject.getClass(), this.expression.getExpressionString(), "An ELException occurred getting the value for expression '" + this.getExpressionString() + "' on context [" + rootObject.getClass() + "]", e);
        }
    }

    public Class getValueType(Object rootObject) throws EvaluationException {
        try {
            this.evaluationContext.setRootObject(rootObject);
            return this.expression.getValueType((EvaluationContext)this.evaluationContext);
        }
        catch (SpelEvaluationException e) {
            if (e.getMessageCode().equals((Object)SpelMessage.PROPERTY_OR_FIELD_NOT_READABLE)) {
                throw new PropertyNotFoundException(rootObject.getClass(), this.getExpressionString(), e);
            }
            throw new EvaluationException(rootObject.getClass(), this.getExpressionString(), "An ELException occurred getting the value type for expression '" + this.getExpressionString() + "' on context [" + rootObject.getClass() + "]", e);
        }
    }

    public void setValue(Object rootObject, Object value) throws EvaluationException {
        try {
            this.updateEvaluationContext(rootObject);
            this.expression.setValue((EvaluationContext)this.evaluationContext, value);
        }
        catch (SpelEvaluationException e) {
            if (e.getMessageCode().equals((Object)SpelMessage.PROPERTY_OR_FIELD_NOT_WRITABLE)) {
                throw new PropertyNotFoundException(rootObject.getClass(), this.getExpressionString(), e);
            }
            if (e.getMessageCode().equals((Object)SpelMessage.EXCEPTION_DURING_PROPERTY_WRITE)) {
                throw new ValueCoercionException(rootObject.getClass(), this.getExpressionString(), value, this.expectedType, e);
            }
            throw new EvaluationException(rootObject.getClass(), this.getExpressionString(), "An ELException occurred setting the value of expression '" + this.getExpressionString() + "' on context [" + rootObject.getClass() + "] to [" + value + "]", e);
        }
    }

    private void updateEvaluationContext(Object rootObject) {
        this.evaluationContext.setRootObject(rootObject);
        this.evaluationContext.setVariables(this.getVariableValues(rootObject));
    }

    private Map getVariableValues(Object rootObject) {
        if (this.expressionVariables == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap variableValues = new HashMap(this.expressionVariables.size());
        for (Map.Entry var : this.expressionVariables.entrySet()) {
            variableValues.put(var.getKey(), ((Expression)var.getValue()).getValue(rootObject));
        }
        return variableValues;
    }

    public String toString() {
        return this.getExpressionString();
    }
}

