/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded.agent;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.springsource.loaded.Constants;
import sl.org.objectweb.asm.ClassReader;
import sl.org.objectweb.asm.ClassVisitor;
import sl.org.objectweb.asm.ClassWriter;
import sl.org.objectweb.asm.MethodVisitor;

public class CglibPluginCapturing
extends ClassVisitor
implements Constants {
    public static Map<Class<?>, Object[]> clazzToGeneratorStrategyAndClassGeneratorMap = new HashMap();
    public static Map<Class<?>, Object[]> clazzToGeneratorStrategyAndFastClassGeneratorMap = new HashMap();
    public String prefix;

    public static byte[] catchGenerate(byte[] bytesIn) {
        ClassReader cr = new ClassReader(bytesIn);
        CglibPluginCapturing ca = new CglibPluginCapturing();
        cr.accept(ca, 0);
        byte[] newbytes = ca.getBytes();
        return newbytes;
    }

    private CglibPluginCapturing() {
        super(327680, new ClassWriter(0));
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        int index = name.indexOf("/cglib");
        this.prefix = name.substring(0, index);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public byte[] getBytes() {
        return ((ClassWriter)this.cv).toByteArray();
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (name.equals("create")) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            return new CreateMethodInterceptor(mv);
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    public static void record(Object a, Object b) {
        String generatorName = b.getClass().getName();
        if (generatorName.endsWith(".cglib.proxy.Enhancer")) {
            try {
                Field f = b.getClass().getDeclaredField("superclass");
                f.setAccessible(true);
                Class clazz = (Class)f.get(b);
                clazzToGeneratorStrategyAndClassGeneratorMap.put(clazz, new Object[]{a, b});
            }
            catch (Throwable re) {
                re.printStackTrace();
            }
        } else if (generatorName.endsWith(".cglib.reflect.FastClass$Generator")) {
            try {
                Field f = b.getClass().getDeclaredField("type");
                f.setAccessible(true);
                Class clazz = (Class)f.get(b);
                clazzToGeneratorStrategyAndFastClassGeneratorMap.put(clazz, new Object[]{a, b});
            }
            catch (Throwable re) {
                re.printStackTrace();
            }
        }
    }

    class CreateMethodInterceptor
    extends MethodVisitor
    implements Constants {
        public CreateMethodInterceptor(MethodVisitor mv) {
            super(327680, mv);
        }

        public void visitCode() {
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            super.visitMethodInsn(opcode, owner, name, desc);
            if (name.equals("generate")) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(180, CglibPluginCapturing.this.prefix + "/cglib/core/AbstractClassGenerator", "strategy", "L" + CglibPluginCapturing.this.prefix + "/cglib/core/GeneratorStrategy;");
                this.mv.visitVarInsn(25, 0);
                this.mv.visitMethodInsn(184, "org/springsource/loaded/agent/CglibPluginCapturing", "record", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            }
        }
    }
}

