/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.toplink.support;

import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.sessions.Session;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.support.DaoSupport;
import org.springframework.orm.toplink.SessionFactory;
import org.springframework.orm.toplink.SessionFactoryUtils;
import org.springframework.orm.toplink.TopLinkTemplate;

public abstract class TopLinkDaoSupport
extends DaoSupport {
    private TopLinkTemplate topLinkTemplate;

    public final void setSessionFactory(SessionFactory sessionFactory) {
        this.topLinkTemplate = this.createTopLinkTemplate(sessionFactory);
    }

    protected TopLinkTemplate createTopLinkTemplate(SessionFactory sessionFactory) {
        return new TopLinkTemplate(sessionFactory);
    }

    public final SessionFactory getSessionFactory() {
        return this.topLinkTemplate != null ? this.topLinkTemplate.getSessionFactory() : null;
    }

    public final void setTopLinkTemplate(TopLinkTemplate topLinkTemplate) {
        this.topLinkTemplate = topLinkTemplate;
    }

    public final TopLinkTemplate getTopLinkTemplate() {
        return this.topLinkTemplate;
    }

    protected final void checkDaoConfig() {
        if (this.topLinkTemplate == null) {
            throw new IllegalArgumentException("sessionFactory or topLinkTemplate is required");
        }
    }

    protected final Session getSession() throws DataAccessResourceFailureException, IllegalStateException {
        return this.getSession(this.topLinkTemplate.isAllowCreate());
    }

    protected final Session getSession(boolean allowCreate) throws DataAccessResourceFailureException, IllegalStateException {
        return SessionFactoryUtils.getSession(this.getSessionFactory(), allowCreate);
    }

    protected final DataAccessException convertTopLinkAccessException(TopLinkException ex) {
        return this.topLinkTemplate.convertTopLinkAccessException(ex);
    }

    protected final void releaseSession(Session session) {
        SessionFactoryUtils.releaseSession(session, this.getSessionFactory());
    }
}

