/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.dao.support;

import java.util.Iterator;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.dao.support.ChainedPersistenceExceptionTranslator;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class PersistenceExceptionTranslationInterceptor
implements MethodInterceptor,
BeanFactoryAware,
InitializingBean {
    private PersistenceExceptionTranslator persistenceExceptionTranslator;
    static /* synthetic */ Class class$org$springframework$dao$support$PersistenceExceptionTranslator;

    public PersistenceExceptionTranslationInterceptor() {
    }

    public PersistenceExceptionTranslationInterceptor(PersistenceExceptionTranslator persistenceExceptionTranslator) {
        this.setPersistenceExceptionTranslator(persistenceExceptionTranslator);
    }

    public PersistenceExceptionTranslationInterceptor(ListableBeanFactory beanFactory) {
        this.persistenceExceptionTranslator = this.detectPersistenceExceptionTranslators(beanFactory);
    }

    public void setPersistenceExceptionTranslator(PersistenceExceptionTranslator pet) {
        Assert.notNull(pet, "PersistenceExceptionTranslator must not be null");
        this.persistenceExceptionTranslator = pet;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.persistenceExceptionTranslator == null) {
            if (!(beanFactory instanceof ListableBeanFactory)) {
                throw new IllegalArgumentException("Cannot use PersistenceExceptionTranslator autodetection without ListableBeanFactory");
            }
            this.persistenceExceptionTranslator = this.detectPersistenceExceptionTranslators((ListableBeanFactory)beanFactory);
        }
    }

    public void afterPropertiesSet() {
        if (this.persistenceExceptionTranslator == null) {
            throw new IllegalArgumentException("Property 'persistenceExceptionTranslator' is required");
        }
    }

    protected PersistenceExceptionTranslator detectPersistenceExceptionTranslators(ListableBeanFactory beanFactory) {
        Map pets = BeanFactoryUtils.beansOfTypeIncludingAncestors(beanFactory, class$org$springframework$dao$support$PersistenceExceptionTranslator == null ? (class$org$springframework$dao$support$PersistenceExceptionTranslator = PersistenceExceptionTranslationInterceptor.class$("org.springframework.dao.support.PersistenceExceptionTranslator")) : class$org$springframework$dao$support$PersistenceExceptionTranslator, false, false);
        if (pets.isEmpty()) {
            throw new IllegalStateException("No persistence exception translators found in bean factory. Cannot perform exception translation.");
        }
        ChainedPersistenceExceptionTranslator cpet = new ChainedPersistenceExceptionTranslator();
        Iterator it = pets.values().iterator();
        while (it.hasNext()) {
            cpet.addDelegate((PersistenceExceptionTranslator)it.next());
        }
        return cpet;
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        try {
            return mi.proceed();
        }
        catch (RuntimeException ex) {
            if (ReflectionUtils.declaresException(mi.getMethod(), ex.getClass())) {
                throw ex;
            }
            throw DataAccessUtils.translateIfNecessary(ex, this.persistenceExceptionTranslator);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

