/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aspectj.weaver.tools.JoinPointMatch;
import org.aspectj.weaver.tools.PointcutExpression;
import org.aspectj.weaver.tools.PointcutParameter;
import org.aspectj.weaver.tools.PointcutParser;
import org.aspectj.weaver.tools.PointcutPrimitive;
import org.aspectj.weaver.tools.ShadowMatch;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.IntroductionAwareMethodMatcher;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.aspectj.RuntimeTestWalker;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.aop.interceptor.ExposeInvocationInterceptor;
import org.springframework.aop.support.AbstractExpressionPointcut;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class AspectJExpressionPointcut
extends AbstractExpressionPointcut
implements ClassFilter,
IntroductionAwareMethodMatcher {
    private static final Set DEFAULT_SUPPORTED_PRIMITIVES = new HashSet();
    private final Map shadowMapCache = new HashMap();
    private PointcutParser pointcutParser;
    private Class pointcutDeclarationScope;
    private String[] pointcutParameterNames = new String[0];
    private Class[] pointcutParameterTypes = new Class[0];
    private PointcutExpression pointcutExpression;

    public AspectJExpressionPointcut() {
        this(DEFAULT_SUPPORTED_PRIMITIVES);
    }

    public AspectJExpressionPointcut(Set supportedPrimitives) {
        this.pointcutParser = PointcutParser.getPointcutParserSupportingSpecifiedPrimitivesAndUsingContextClassloaderForResolution((Set)supportedPrimitives);
    }

    public AspectJExpressionPointcut(Class declarationScope, String[] paramNames, Class[] paramTypes) {
        this(DEFAULT_SUPPORTED_PRIMITIVES);
        this.pointcutDeclarationScope = declarationScope;
        if (paramNames.length != paramTypes.length) {
            throw new IllegalStateException("Number of pointcut parameter names must match number of pointcut parameter types");
        }
        this.pointcutParameterNames = paramNames;
        this.pointcutParameterTypes = paramTypes;
    }

    public void setPointcutDeclarationScope(Class pointcutDeclarationScope) {
        this.pointcutDeclarationScope = pointcutDeclarationScope;
    }

    public void setParameterNames(String[] names) {
        this.pointcutParameterNames = names;
    }

    public void setParameterTypes(Class[] types) {
        this.pointcutParameterTypes = types;
    }

    public ClassFilter getClassFilter() {
        this.checkReadyToMatch();
        return this;
    }

    public MethodMatcher getMethodMatcher() {
        this.checkReadyToMatch();
        return this;
    }

    private void checkReadyToMatch() {
        if (this.getExpression() == null) {
            throw new IllegalStateException("Must set property [expression] before attempting to match.");
        }
        if (this.pointcutExpression == null) {
            this.buildPointcutExpression();
        }
    }

    private void buildPointcutExpression() {
        PointcutParameter[] pointcutParameters = new PointcutParameter[this.pointcutParameterNames.length];
        for (int i = 0; i < pointcutParameters.length; ++i) {
            pointcutParameters[i] = this.pointcutParser.createPointcutParameter(this.pointcutParameterNames[i], this.pointcutParameterTypes[i]);
        }
        this.pointcutExpression = this.pointcutParser.parsePointcutExpression(this.replaceBooleanOperators(this.getExpression()), this.pointcutDeclarationScope, pointcutParameters);
    }

    private String replaceBooleanOperators(String pcExpr) {
        pcExpr = StringUtils.replace(pcExpr, " and ", " && ");
        pcExpr = StringUtils.replace(pcExpr, " or ", " || ");
        pcExpr = StringUtils.replace(pcExpr, " not ", " ! ");
        return pcExpr;
    }

    public PointcutExpression getPointcutExpression() {
        this.checkReadyToMatch();
        return this.pointcutExpression;
    }

    public boolean matches(Class targetClass) {
        this.checkReadyToMatch();
        return this.pointcutExpression.couldMatchJoinPointsInType(targetClass);
    }

    public boolean matches(Method method, Class targetClass) {
        return this.matches(method, targetClass, false);
    }

    public boolean isRuntime() {
        this.checkReadyToMatch();
        return this.pointcutExpression.mayNeedDynamicTest();
    }

    public boolean matches(Method method, Class targetClass, boolean beanHasIntroductions) {
        this.checkReadyToMatch();
        Method methodToMatch = this.findMethodToMatchAgainst(method, targetClass);
        ShadowMatch shadowMatch = this.getShadowMatch(methodToMatch);
        if (shadowMatch.alwaysMatches()) {
            return true;
        }
        if (shadowMatch.neverMatches()) {
            return false;
        }
        if (!beanHasIntroductions) {
            return this.matchesIgnoringSubtypes(shadowMatch);
        }
        return true;
    }

    private Method findMethodToMatchAgainst(Method method, Class targetClass) {
        Class<?> declaredClass = method.getDeclaringClass();
        if (declaredClass.isInterface()) {
            Class<?>[] ptypes = method.getParameterTypes();
            String name = method.getName();
            while (true) {
                try {
                    return targetClass.getDeclaredMethod(name, ptypes);
                }
                catch (NoSuchMethodException ex) {
                    if ((targetClass = targetClass.getSuperclass()) != null) continue;
                    return method;
                }
                break;
            }
        }
        return method;
    }

    private boolean matchesIgnoringSubtypes(ShadowMatch shadowMatch) {
        return !new RuntimeTestWalker(shadowMatch).testsSubtypeSensitiveVars();
    }

    public boolean matches(Method method, Class targetClass, Object[] args) {
        Object thisObject;
        Object targetObject;
        ReflectiveMethodInvocation invocation;
        this.checkReadyToMatch();
        Method methodToMatch = this.findMethodToMatchAgainst(method, targetClass);
        ShadowMatch shadowMatch = this.getShadowMatch(methodToMatch);
        try {
            invocation = (ReflectiveMethodInvocation)ExposeInvocationInterceptor.currentInvocation();
            targetObject = invocation.getThis();
            thisObject = invocation.getProxy();
        }
        catch (IllegalStateException ex) {
            targetObject = null;
            thisObject = null;
            invocation = null;
        }
        JoinPointMatch joinPointMatch = shadowMatch.matchesJoinPoint(thisObject, targetObject, args);
        if (joinPointMatch.matches() && invocation != null) {
            this.bindParameters(invocation, joinPointMatch);
        }
        return joinPointMatch.matches();
    }

    private void bindParameters(ReflectiveMethodInvocation invocation, JoinPointMatch jpm) {
        invocation.setUserAttribute(this.getExpression(), jpm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShadowMatch getShadowMatch(Method method) {
        Map map = this.shadowMapCache;
        synchronized (map) {
            ShadowMatch shadowMatch = (ShadowMatch)this.shadowMapCache.get(method);
            if (shadowMatch == null) {
                shadowMatch = this.pointcutExpression.matchesMethodExecution(method);
                this.shadowMapCache.put(method, shadowMatch);
            }
            return shadowMatch;
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AspectJExpressionPointcut)) {
            return false;
        }
        AspectJExpressionPointcut otherPc = (AspectJExpressionPointcut)other;
        return ObjectUtils.nullSafeEquals(this.getExpression(), otherPc.getExpression()) && ObjectUtils.nullSafeEquals(this.pointcutDeclarationScope, otherPc.pointcutDeclarationScope) && ObjectUtils.nullSafeEquals(this.pointcutParameterNames, otherPc.pointcutParameterNames) && ObjectUtils.nullSafeEquals(this.pointcutParameterTypes, otherPc.pointcutParameterTypes);
    }

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode(this.getExpression());
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.pointcutDeclarationScope);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.pointcutParameterNames);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.pointcutParameterTypes);
        return hashCode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AspectJExpressionPointcut: ");
        if (this.pointcutParameterNames != null && this.pointcutParameterTypes != null) {
            sb.append("(");
            for (int i = 0; i < this.pointcutParameterTypes.length; ++i) {
                sb.append(this.pointcutParameterTypes[i].getName());
                sb.append(" ");
                sb.append(this.pointcutParameterNames[i]);
                if (i + 1 >= this.pointcutParameterTypes.length) continue;
                sb.append(", ");
            }
            sb.append(")");
        }
        sb.append(" ");
        if (this.getExpression() != null) {
            sb.append(this.getExpression());
        } else {
            sb.append("<pointcut expression not set>");
        }
        return sb.toString();
    }

    static {
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.EXECUTION);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.ARGS);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.REFERENCE);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.THIS);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.TARGET);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.WITHIN);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.AT_ANNOTATION);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.AT_WITHIN);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.AT_ARGS);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.AT_TARGET);
    }
}

