/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.jsp.JspException;
import org.springframework.util.ObjectUtils;
import org.springframework.web.servlet.tags.form.AbstractHtmlElementBodyTag;
import org.springframework.web.servlet.tags.form.TagWriter;

public class ErrorsTag
extends AbstractHtmlElementBodyTag {
    private static final String MESSAGES_ATTRIBUTE = "messages";
    public static final String SPAN_TAG = "span";
    private String delimiter = "<br/>";

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    protected String getName() throws JspException {
        return this.getPath() + ".errors";
    }

    protected boolean shouldRender() throws JspException {
        return this.getBindStatus().isError();
    }

    protected void renderDefaultContent(TagWriter tagWriter) throws JspException {
        tagWriter.startTag(SPAN_TAG);
        this.writeDefaultAttributes(tagWriter);
        String delimiter = ObjectUtils.getDisplayString(this.evaluate("delimiter", this.delimiter));
        String[] errorMessages = this.getBindStatus().getErrorMessages();
        for (int i = 0; i < errorMessages.length; ++i) {
            String errorMessage = errorMessages[i];
            if (i > 0) {
                tagWriter.appendValue(delimiter);
            }
            tagWriter.appendValue(errorMessage);
        }
        tagWriter.endTag();
    }

    protected void exposeAttributes() throws JspException {
        ArrayList<String> errorMessages = new ArrayList<String>();
        errorMessages.addAll(Arrays.asList(this.getBindStatus().getErrorMessages()));
        this.pageContext.setAttribute(MESSAGES_ATTRIBUTE, errorMessages);
    }

    protected void removeAttributes() {
        this.pageContext.removeAttribute(MESSAGES_ATTRIBUTE);
    }
}

