/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import org.springframework.web.context.request.RequestAttributes;

public abstract class RequestContextHolder {
    public static ThreadLocal attributeAccessorHolder = new InheritableThreadLocal();

    public static void setRequestAttributes(RequestAttributes accessor) {
        attributeAccessorHolder.set(accessor);
    }

    public static RequestAttributes getRequestAttributes() {
        return (RequestAttributes)attributeAccessorHolder.get();
    }

    public static RequestAttributes currentRequestAttributes() throws IllegalStateException {
        RequestAttributes accessor = (RequestAttributes)attributeAccessorHolder.get();
        if (accessor == null) {
            throw new IllegalStateException("No thread-bound request: use RequestContextFilter");
        }
        return accessor;
    }
}

