/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class CollectionUtils {
    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean contains(Iterator iterator, Object element) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object candidate = iterator.next();
                if (!ObjectUtils.nullSafeEquals(candidate, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Enumeration enumeration, Object element) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object candidate = enumeration.nextElement();
                if (!ObjectUtils.nullSafeEquals(candidate, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasUniqueObject(Collection coll) {
        if (coll.isEmpty()) {
            return false;
        }
        boolean hasCandidate = false;
        Object candidate = null;
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            Object elem = it.next();
            if (!hasCandidate) {
                hasCandidate = true;
                candidate = elem;
                continue;
            }
            if (candidate == elem) continue;
            return false;
        }
        return true;
    }

    public static Object findValueOfType(Collection coll, Class type) throws IllegalArgumentException {
        Object value = null;
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!type.isInstance(obj)) continue;
            if (value != null) {
                throw new IllegalArgumentException("More than one value of type [" + type.getName() + "] found");
            }
            value = obj;
        }
        return value;
    }

    public static Object findValueOfType(Collection coll, Class[] types) throws IllegalArgumentException {
        for (int i = 0; i < types.length; ++i) {
            Object value = CollectionUtils.findValueOfType(coll, types[i]);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static List arrayToList(Object source) {
        Assert.notNull(source, "Source array must not be null");
        if (!source.getClass().isArray()) {
            throw new IllegalArgumentException("Source is not an array: " + source);
        }
        boolean primitive = source.getClass().getComponentType().isPrimitive();
        Object[] array = primitive ? ObjectUtils.toObjectArray(source) : (Object[])source;
        return Arrays.asList(array);
    }

    public static void mergePropertiesIntoMap(Properties props, Map map) {
        Assert.notNull(map, "Map must not be null");
        if (props != null) {
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                map.put(key, props.getProperty(key));
            }
        }
    }

    public static boolean containsAny(Collection source, Collection candidates) {
        Iterator iterator = candidates.iterator();
        while (iterator.hasNext()) {
            if (!source.contains(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static Object findFirstMatch(Collection source, Collection candidates) {
        Iterator iterator = candidates.iterator();
        while (iterator.hasNext()) {
            Object candidate = iterator.next();
            if (!source.contains(candidate)) continue;
            return candidate;
        }
        return null;
    }
}

