/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.connection;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import org.springframework.jms.connection.JmsResourceHolder;
import org.springframework.jms.support.JmsUtils;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public abstract class ConnectionFactoryUtils {
    static /* synthetic */ Class class$javax$jms$QueueConnection;
    static /* synthetic */ Class class$javax$jms$QueueSession;
    static /* synthetic */ Class class$javax$jms$TopicConnection;
    static /* synthetic */ Class class$javax$jms$TopicSession;

    public static Session getTransactionalSession(final ConnectionFactory cf) throws JMSException {
        return ConnectionFactoryUtils.doGetTransactionalSession(cf, new ResourceFactory(){

            public Connection getConnection(JmsResourceHolder holder) {
                return holder.getConnection();
            }

            public Session getSession(JmsResourceHolder holder) {
                return holder.getSession();
            }

            public Connection createConnection() throws JMSException {
                return cf.createConnection();
            }

            public Session createSession(Connection con) throws JMSException {
                return con.createSession(false, 1);
            }
        });
    }

    public static QueueSession getTransactionalQueueSession(final QueueConnectionFactory cf) throws JMSException {
        return (QueueSession)ConnectionFactoryUtils.doGetTransactionalSession(cf, new ResourceFactory(){

            public Connection getConnection(JmsResourceHolder holder) {
                return holder.getConnection(class$javax$jms$QueueConnection == null ? (class$javax$jms$QueueConnection = ConnectionFactoryUtils.class$("javax.jms.QueueConnection")) : class$javax$jms$QueueConnection);
            }

            public Session getSession(JmsResourceHolder holder) {
                return holder.getSession(class$javax$jms$QueueSession == null ? (class$javax$jms$QueueSession = ConnectionFactoryUtils.class$("javax.jms.QueueSession")) : class$javax$jms$QueueSession);
            }

            public Connection createConnection() throws JMSException {
                return cf.createQueueConnection();
            }

            public Session createSession(Connection con) throws JMSException {
                return ((QueueConnection)con).createQueueSession(false, 1);
            }
        });
    }

    public static TopicSession getTransactionalTopicSession(final TopicConnectionFactory cf) throws JMSException {
        return (TopicSession)ConnectionFactoryUtils.doGetTransactionalSession(cf, new ResourceFactory(){

            public Connection getConnection(JmsResourceHolder holder) {
                return holder.getConnection(class$javax$jms$TopicConnection == null ? (class$javax$jms$TopicConnection = ConnectionFactoryUtils.class$("javax.jms.TopicConnection")) : class$javax$jms$TopicConnection);
            }

            public Session getSession(JmsResourceHolder holder) {
                return holder.getSession(class$javax$jms$TopicSession == null ? (class$javax$jms$TopicSession = ConnectionFactoryUtils.class$("javax.jms.TopicSession")) : class$javax$jms$TopicSession);
            }

            public Connection createConnection() throws JMSException {
                return cf.createTopicConnection();
            }

            public Session createSession(Connection con) throws JMSException {
                return ((TopicConnection)con).createTopicSession(false, 1);
            }
        });
    }

    public static Session doGetTransactionalSession(Object resourceKey, ResourceFactory resourceFactory) throws JMSException {
        Session session;
        Assert.notNull(resourceKey, "Resource key must not be null");
        Assert.notNull(resourceKey, "ResourceFactory must not be null");
        JmsResourceHolder conHolder = (JmsResourceHolder)TransactionSynchronizationManager.getResource(resourceKey);
        if (conHolder != null && ((session = resourceFactory.getSession(conHolder)) != null || conHolder.isFrozen())) {
            return session;
        }
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            return null;
        }
        JmsResourceHolder conHolderToUse = conHolder;
        if (conHolderToUse == null) {
            conHolderToUse = new JmsResourceHolder();
        }
        Connection con = resourceFactory.getConnection(conHolderToUse);
        Session session2 = null;
        try {
            boolean isExistingCon;
            boolean bl = isExistingCon = con != null;
            if (!isExistingCon) {
                con = resourceFactory.createConnection();
                conHolderToUse.addConnection(con);
            }
            session2 = resourceFactory.createSession(con);
            conHolderToUse.addSession(session2);
            if (!isExistingCon) {
                con.start();
            }
        }
        catch (JMSException ex) {
            JmsUtils.closeSession(session2);
            JmsUtils.closeConnection(con);
            throw ex;
        }
        if (conHolderToUse != conHolder) {
            TransactionSynchronizationManager.registerSynchronization(new JmsResourceSynchronization(resourceKey, conHolderToUse));
            conHolderToUse.setSynchronizedWithTransaction(true);
            TransactionSynchronizationManager.bindResource(resourceKey, conHolderToUse);
        }
        return session2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class JmsResourceSynchronization
    extends TransactionSynchronizationAdapter {
        private final Object resourceKey;
        private final JmsResourceHolder resourceHolder;
        private boolean holderActive = true;

        public JmsResourceSynchronization(Object resourceKey, JmsResourceHolder resourceHolder) {
            this.resourceKey = resourceKey;
            this.resourceHolder = resourceHolder;
        }

        public void suspend() {
            if (this.holderActive) {
                TransactionSynchronizationManager.unbindResource(this.resourceKey);
            }
        }

        public void resume() {
            if (this.holderActive) {
                TransactionSynchronizationManager.bindResource(this.resourceKey, this.resourceHolder);
            }
        }

        public void beforeCompletion() {
            TransactionSynchronizationManager.unbindResource(this.resourceKey);
            this.holderActive = false;
            this.resourceHolder.closeAll();
        }
    }

    public static interface ResourceFactory {
        public Connection getConnection(JmsResourceHolder var1);

        public Session getSession(JmsResourceHolder var1);

        public Connection createConnection() throws JMSException;

        public Session createSession(Connection var1) throws JMSException;
    }
}

