/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WeavingTransformer {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final boolean trace = this.logger.isTraceEnabled();
    private final ClassLoader classLoader;
    private List<ClassFileTransformer> transformers = new ArrayList<ClassFileTransformer>();

    private static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = WeavingTransformer.class.getClassLoader();
        }
        return cl;
    }

    public WeavingTransformer() {
        this(null);
    }

    public WeavingTransformer(ClassLoader classLoader) {
        this.classLoader = classLoader != null ? classLoader : WeavingTransformer.getDefaultClassLoader();
    }

    public void addTransformer(ClassFileTransformer cft) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("adding transformer " + cft));
        }
        this.transformers.add(cft);
    }

    public byte[] transformIfNecessary(String className, String internalName, byte[] bytes, ProtectionDomain pd) {
        for (ClassFileTransformer cft : this.transformers) {
            try {
                byte[] transformed = cft.transform(this.classLoader, internalName, null, pd, bytes);
                if (transformed == null) {
                    if (!this.trace) continue;
                    this.logger.trace((Object)("Not Weaving: " + className + " w/ transformer " + cft));
                    continue;
                }
                if (this.trace) {
                    this.logger.trace((Object)("Weaving: " + className + " w/ transformer " + cft));
                }
                bytes = transformed;
            }
            catch (IllegalClassFormatException ex) {
                throw new RuntimeException("Cannot transform", ex);
            }
        }
        return bytes;
    }

    public byte[] transformIfNecessary(String className, byte[] bytes, ProtectionDomain pd) {
        String internalName = className.replace(".", "/");
        return this.transformIfNecessary(className, internalName, bytes, pd);
    }
}

