/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory;

import org.springframework.beans.FatalBeanException;

public class CannotLoadBeanClassException
extends FatalBeanException {
    private String resourceDescription;
    private String beanName;
    private String beanClassName;

    public CannotLoadBeanClassException(String resourceDescription, String beanName, String beanClassName, ClassNotFoundException ex) {
        super("Error loading class [" + beanClassName + "] of bean with name '" + beanName + "' defined in " + resourceDescription, ex);
        this.resourceDescription = resourceDescription;
        this.beanName = beanName;
        this.beanClassName = beanClassName;
    }

    public CannotLoadBeanClassException(String resourceDescription, String beanName, String beanClassName, NoClassDefFoundError err) {
        super("Error loading class that [" + beanClassName + "] of bean with name '" + beanName + "' defined in " + resourceDescription + ": dependency not found", err);
        this.resourceDescription = resourceDescription;
        this.beanName = beanName;
        this.beanClassName = beanClassName;
    }

    public String getResourceDescription() {
        return this.resourceDescription;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getBeanClassName() {
        return this.beanClassName;
    }
}

