/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.annotation;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.AbstractFallbackTransactionAttributeSource;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;

public class AnnotationTransactionAttributeSource
extends AbstractFallbackTransactionAttributeSource
implements Serializable {
    protected Collection findAllAttributes(Method method) {
        return Arrays.asList(AnnotationUtils.getAnnotations(method));
    }

    protected Collection findAllAttributes(Class clazz) {
        return Arrays.asList(clazz.getAnnotations());
    }

    protected TransactionAttribute findTransactionAttribute(Collection atts) {
        if (atts == null) {
            return null;
        }
        for (Object att : atts) {
            if (!(att instanceof Transactional)) continue;
            Transactional ruleBasedTx = (Transactional)att;
            RuleBasedTransactionAttribute rbta = new RuleBasedTransactionAttribute();
            rbta.setPropagationBehavior(ruleBasedTx.propagation().value());
            rbta.setIsolationLevel(ruleBasedTx.isolation().value());
            rbta.setReadOnly(ruleBasedTx.readOnly());
            ArrayList<RollbackRuleAttribute> rollBackRules = new ArrayList<RollbackRuleAttribute>();
            Class<? extends Throwable>[] rbf = ruleBasedTx.rollbackFor();
            for (int i = 0; i < rbf.length; ++i) {
                RollbackRuleAttribute rule = new RollbackRuleAttribute(rbf[i]);
                rollBackRules.add(rule);
            }
            String[] rbfc = ruleBasedTx.rollbackForClassName();
            for (int i = 0; i < rbfc.length; ++i) {
                RollbackRuleAttribute rule = new RollbackRuleAttribute(rbfc[i]);
                rollBackRules.add(rule);
            }
            Class<? extends Throwable>[] nrbf = ruleBasedTx.noRollbackFor();
            for (int i = 0; i < nrbf.length; ++i) {
                NoRollbackRuleAttribute rule = new NoRollbackRuleAttribute(nrbf[i]);
                rollBackRules.add(rule);
            }
            String[] nrbfc = ruleBasedTx.noRollbackForClassName();
            for (int i = 0; i < nrbfc.length; ++i) {
                NoRollbackRuleAttribute rule = new NoRollbackRuleAttribute(nrbfc[i]);
                rollBackRules.add(rule);
            }
            rbta.getRollbackRules().addAll(rollBackRules);
            return rbta;
        }
        return null;
    }
}

