/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.support.SQLExceptionTranslator;

public class SQLStateSQLExceptionTranslator
implements SQLExceptionTranslator {
    private static final Set BAD_SQL_CODES = new HashSet(3);
    private static final Set INTEGRITY_VIOLATION_CODES = new HashSet(4);
    protected final Log logger = LogFactory.getLog(this.getClass());

    public DataAccessException translate(String task, String sql, SQLException sqlEx) {
        SQLException nestedEx;
        String sqlState;
        if (task == null) {
            task = "";
        }
        if (sql == null) {
            sql = "";
        }
        if ((sqlState = sqlEx.getSQLState()) == null && (nestedEx = sqlEx.getNextException()) != null) {
            sqlState = nestedEx.getSQLState();
        }
        if (sqlState != null && sqlState.length() >= 2) {
            String classCode = sqlState.substring(0, 2);
            if (BAD_SQL_CODES.contains(classCode)) {
                return new BadSqlGrammarException(task, sql, sqlEx);
            }
            if (INTEGRITY_VIOLATION_CODES.contains(classCode)) {
                return new DataIntegrityViolationException(this.buildMessage(task, sql, sqlEx), sqlEx);
            }
        }
        return new UncategorizedSQLException(task, sql, sqlEx);
    }

    protected String buildMessage(String task, String sql, SQLException sqlEx) {
        return task + "; SQL [" + sql + "]; " + sqlEx.getMessage();
    }

    static {
        BAD_SQL_CODES.add("07");
        BAD_SQL_CODES.add("42");
        BAD_SQL_CODES.add("65");
        INTEGRITY_VIOLATION_CODES.add("22");
        INTEGRITY_VIOLATION_CODES.add("23");
        INTEGRITY_VIOLATION_CODES.add("27");
        INTEGRITY_VIOLATION_CODES.add("44");
    }
}

