/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import javax.servlet.jsp.JspException;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.tags.form.AbstractFormTag;
import org.springframework.web.servlet.tags.form.TagWriter;

public abstract class AbstractDataBoundFormElementTag
extends AbstractFormTag {
    public static final String ID_ATTRIBUTE = "id";
    private BindStatus bindStatus;
    private String id;
    private String path;

    public void setPath(String path) {
        Assert.hasText(path, "'path' cannot be null or zero length.");
        this.path = path;
    }

    public void setId(String id) {
        Assert.notNull(id, "'id' cannot be null.");
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    protected final String getPath() throws JspException {
        return (String)this.evaluate("path", this.path);
    }

    protected void writeDefaultAttributes(TagWriter tagWriter) throws JspException {
        String id = this.getId();
        if (StringUtils.hasText(id)) {
            tagWriter.writeAttribute(ID_ATTRIBUTE, ObjectUtils.getDisplayString(this.evaluate(ID_ATTRIBUTE, id)));
        } else {
            tagWriter.writeAttribute(ID_ATTRIBUTE, this.autogenerateId());
        }
        tagWriter.writeAttribute("name", this.getName());
    }

    protected String autogenerateId() throws JspException {
        return this.getName();
    }

    protected String getName() throws JspException {
        String nestedPath = this.getNestedPath();
        return nestedPath == null ? this.getPath() : nestedPath + this.getPath();
    }

    protected final Object getBoundValue() throws JspException {
        return this.getBindStatus().getValue();
    }

    protected BindStatus getBindStatus() throws JspException {
        if (this.bindStatus == null) {
            String resolvedPropertyPath = this.getPath();
            String bindPath = this.getBindPath(resolvedPropertyPath);
            this.bindStatus = new BindStatus(this.getRequestContext(), bindPath, this.isHtmlEscape());
        }
        return this.bindStatus;
    }

    private String getBindPath(String resolvedSubPath) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getCommandName());
        String nestedPath = this.getNestedPath();
        if (nestedPath != null) {
            sb.append('.').append(nestedPath);
        }
        if (resolvedSubPath != null) {
            if (sb.charAt(sb.length() - 1) != '.') {
                sb.append('.');
            }
            sb.append(resolvedSubPath);
        }
        return sb.toString();
    }

    private String getNestedPath() {
        return (String)this.pageContext.getAttribute("nestedPath", 2);
    }

    private String getCommandName() {
        return (String)this.pageContext.getAttribute("org.springframework.web.servlet.tags.form.FormTag.commandName");
    }

    public void doFinally() {
        super.doFinally();
        this.bindStatus = null;
    }
}

