/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.util.ClassUtils;

public class MethodInvoker {
    private Class targetClass;
    private Object targetObject;
    private String targetMethod;
    private String staticMethod;
    private Object[] arguments;
    private Method methodObject;
    static /* synthetic */ Class class$java$lang$Object;

    public void setTargetClass(Class targetClass) {
        this.targetClass = targetClass;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    public void setTargetObject(Object targetObject) {
        this.targetObject = targetObject;
        if (targetObject != null) {
            this.targetClass = targetObject.getClass();
        }
    }

    public Object getTargetObject() {
        return this.targetObject;
    }

    public void setTargetMethod(String targetMethod) {
        this.targetMethod = targetMethod;
    }

    public String getTargetMethod() {
        return this.targetMethod;
    }

    public void setStaticMethod(String staticMethod) {
        this.staticMethod = staticMethod;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void prepare() throws ClassNotFoundException, NoSuchMethodException {
        block9: {
            if (this.staticMethod != null) {
                int lastDotIndex = this.staticMethod.lastIndexOf(46);
                if (lastDotIndex == -1 || lastDotIndex == this.staticMethod.length()) {
                    throw new IllegalArgumentException("staticMethod must be a fully qualified class plus method name: e.g. 'example.MyExampleClass.myExampleMethod'");
                }
                String className = this.staticMethod.substring(0, lastDotIndex);
                String methodName = this.staticMethod.substring(lastDotIndex + 1);
                this.targetClass = this.resolveClassName(className);
                this.targetMethod = methodName;
            }
            if (this.targetClass == null) {
                throw new IllegalArgumentException("Either targetClass or targetObject is required");
            }
            if (this.targetMethod == null) {
                throw new IllegalArgumentException("targetMethod is required");
            }
            if (this.arguments == null) {
                this.arguments = new Object[0];
            }
            Class[] argTypes = new Class[this.arguments.length];
            for (int i = 0; i < this.arguments.length; ++i) {
                argTypes[i] = this.arguments[i] != null ? this.arguments[i].getClass() : (class$java$lang$Object == null ? MethodInvoker.class$("java.lang.Object") : class$java$lang$Object);
            }
            try {
                this.methodObject = this.targetClass.getMethod(this.targetMethod, argTypes);
            }
            catch (NoSuchMethodException ex) {
                this.methodObject = this.findMatchingMethod();
                if (this.methodObject != null) break block9;
                throw ex;
            }
        }
        if (this.targetObject == null && !Modifier.isStatic(this.methodObject.getModifiers())) {
            throw new IllegalArgumentException("Target method must not be non-static without a target");
        }
    }

    protected Class resolveClassName(String className) throws ClassNotFoundException {
        return ClassUtils.forName(className);
    }

    protected Method findMatchingMethod() {
        String targetMethod = this.getTargetMethod();
        Object[] arguments = this.getArguments();
        int argCount = arguments.length;
        Method[] candidates = this.getTargetClass().getMethods();
        Method matchingMethod = null;
        int numberOfMatchingMethods = 0;
        for (int i = 0; i < candidates.length; ++i) {
            Method candidate = candidates[i];
            Class<?>[] paramTypes = candidate.getParameterTypes();
            int paramCount = paramTypes.length;
            if (!candidate.getName().equals(targetMethod) || paramCount != argCount) continue;
            boolean match = true;
            for (int j = 0; j < paramCount && match; ++j) {
                match = match && ClassUtils.isAssignableValue(paramTypes[j], arguments[j]);
            }
            if (!match) continue;
            matchingMethod = candidate;
            ++numberOfMatchingMethods;
        }
        if (numberOfMatchingMethods == 1) {
            return matchingMethod;
        }
        return null;
    }

    public Method getPreparedMethod() {
        return this.methodObject;
    }

    public Object invoke() throws InvocationTargetException, IllegalAccessException {
        if (this.methodObject == null) {
            throw new IllegalStateException("prepare() must be called prior to invoke() on MethodInvoker");
        }
        return this.methodObject.invoke(this.targetObject, this.arguments);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class VoidType {
    }
}

