/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.namedparam.NamedParameterUtils;
import org.springframework.jdbc.object.RdbmsOperation;

public abstract class SqlOperation
extends RdbmsOperation {
    private PreparedStatementCreatorFactory preparedStatementFactory;

    protected final void compileInternal() {
        int bindVarCount = NamedParameterUtils.countParameterPlaceholders(this.getSql());
        if (bindVarCount != this.getDeclaredParameters().size()) {
            throw new InvalidDataAccessApiUsageException("SQL '" + this.getSql() + "' requires " + bindVarCount + " bind variables, but " + this.getDeclaredParameters().size() + " variables were declared for this object");
        }
        this.preparedStatementFactory = new PreparedStatementCreatorFactory(this.getSql(), this.getDeclaredParameters());
        this.preparedStatementFactory.setResultSetType(this.getResultSetType());
        this.preparedStatementFactory.setUpdatableResults(this.isUpdatableResults());
        this.preparedStatementFactory.setReturnGeneratedKeys(this.isReturnGeneratedKeys());
        if (this.getGeneratedKeysColumnNames() != null) {
            this.preparedStatementFactory.setGeneratedKeysColumnNames(this.getGeneratedKeysColumnNames());
        }
        this.preparedStatementFactory.setNativeJdbcExtractor(this.getJdbcTemplate().getNativeJdbcExtractor());
        this.preparedStatementFactory.setSqlToUse(NamedParameterUtils.parseSqlStatementIntoString(this.getSql()));
        this.onCompileInternal();
    }

    protected void onCompileInternal() {
    }

    protected final PreparedStatementCreator newPreparedStatementCreator(Object[] params) {
        return this.preparedStatementFactory.newPreparedStatementCreator(params);
    }

    protected final PreparedStatementSetter newPreparedStatementSetter(Object[] params) {
        return this.preparedStatementFactory.newPreparedStatementSetter(params);
    }
}

