/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.mvc;

import java.util.Arrays;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.PortletRequestDataBinder;
import org.springframework.web.portlet.handler.PortletSessionRequiredException;
import org.springframework.web.portlet.mvc.BaseCommandController;

public abstract class AbstractFormController
extends BaseCommandController {
    private static final String FORM_SUBMISSION_PARAMETER = "form-submit";
    private static final String INVALID_SUBMISSION_PARAMETER = "invalid-submit";
    private static final String TRUE = Boolean.TRUE.toString();
    private boolean bindOnNewForm = false;
    private boolean sessionForm = false;
    private boolean redirectAction = false;
    private String[] renderParameters = null;

    public AbstractFormController() {
        this.setCacheSeconds(0);
    }

    public final void setBindOnNewForm(boolean bindOnNewForm) {
        this.bindOnNewForm = bindOnNewForm;
    }

    public final boolean isBindOnNewForm() {
        return this.bindOnNewForm;
    }

    public final void setSessionForm(boolean sessionForm) {
        this.sessionForm = sessionForm;
    }

    public final boolean isSessionForm() {
        return this.sessionForm;
    }

    public void setRedirectAction(boolean redirectAction) {
        this.redirectAction = redirectAction;
    }

    public boolean isRedirectAction() {
        return this.redirectAction;
    }

    public void setRenderParameters(String[] parameters) {
        this.renderParameters = parameters;
    }

    public String[] getRenderParameters() {
        return this.renderParameters;
    }

    protected ModelAndView handleRenderRequestInternal(RenderRequest request, RenderResponse response) throws Exception {
        if (this.isFormSubmission((PortletRequest)request)) {
            if (this.isInvalidSubmission((PortletRequest)request)) {
                this.logger.debug((Object)"Invalid submit - calling renderInvalidSubmit");
                return this.renderInvalidSubmit(request, response);
            }
            this.logger.debug((Object)"Valid submit - calling renderFormSubmission");
            return this.renderFormSubmission(request, response, this.getRenderCommand(request), this.getRenderErrors(request));
        }
        return this.showNewForm(request, response);
    }

    protected void handleActionRequestInternal(ActionRequest request, ActionResponse response) throws Exception {
        if (this.isFormSubmission((PortletRequest)request)) {
            try {
                Object command = this.getCommand((PortletRequest)request);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Processing valid submit (redirectAction = " + this.isRedirectAction() + ")"));
                }
                if (!this.isRedirectAction()) {
                    this.setFormSubmit(response);
                }
                PortletRequestDataBinder binder = this.bindAndValidate((PortletRequest)request, command);
                BindException errors = new BindException(binder.getBindingResult());
                this.processFormSubmission(request, response, command, errors);
                this.setRenderCommandAndErrors(request, command, errors);
                return;
            }
            catch (PortletSessionRequiredException ex) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Invalid submit detected: " + ex.getMessage()));
                }
                this.setFormSubmit(response);
                this.setInvalidSubmit(response);
                this.handleInvalidSubmit(request, response);
                return;
            }
        }
        this.logger.debug((Object)"Not a form submit - passing parameters to render phase");
        this.passRenderParameters(request, response);
    }

    protected boolean isFormSubmission(PortletRequest request) {
        return request instanceof ActionRequest ? true : TRUE.equals(request.getParameter(this.getFormSubmitParameterName()));
    }

    protected boolean isInvalidSubmission(PortletRequest request) {
        return TRUE.equals(request.getParameter(this.getInvalidSubmitParameterName()));
    }

    protected String getFormSubmitParameterName() {
        return FORM_SUBMISSION_PARAMETER;
    }

    protected String getInvalidSubmitParameterName() {
        return INVALID_SUBMISSION_PARAMETER;
    }

    protected final void setFormSubmit(ActionResponse response) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Setting render parameter [" + this.getFormSubmitParameterName() + "] to indicate this is a form submission"));
        }
        try {
            response.setRenderParameter(this.getFormSubmitParameterName(), TRUE);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected final void setInvalidSubmit(ActionResponse response) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Setting render parameter [" + this.getInvalidSubmitParameterName() + "] to indicate this is an invalid submission"));
        }
        try {
            response.setRenderParameter(this.getInvalidSubmitParameterName(), TRUE);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected String getFormSessionAttributeName(PortletRequest request) {
        return this.getFormSessionAttributeName();
    }

    protected String getFormSessionAttributeName() {
        return this.getClass().getName() + ".FORM." + this.getCommandName();
    }

    protected void passRenderParameters(ActionRequest request, ActionResponse response) {
        if (this.renderParameters == null) {
            return;
        }
        try {
            for (int i = 0; i < this.renderParameters.length; ++i) {
                String paramName = this.renderParameters[i];
                String[] paramValues = request.getParameterValues(paramName);
                if (paramValues == null) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Passing parameter to render phase '" + paramName + "' = " + (paramValues == null ? "NULL" : Arrays.asList(paramValues).toString())));
                }
                response.setRenderParameter(paramName, paramValues);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected final ModelAndView showNewForm(RenderRequest request, RenderResponse response) throws Exception {
        this.logger.debug((Object)"Displaying new form");
        return this.showForm(request, response, this.getErrorsForNewForm(request));
    }

    protected final BindException getErrorsForNewForm(RenderRequest request) throws Exception {
        Object command = this.formBackingObject((PortletRequest)request);
        if (command == null) {
            throw new PortletException("Form object returned by formBackingObject() must not be null");
        }
        if (!this.checkCommand(command)) {
            throw new PortletException("Form object returned by formBackingObject() must match commandClass");
        }
        PortletRequestDataBinder binder = this.createBinder((PortletRequest)request, command);
        BindException errors = new BindException(binder.getBindingResult());
        if (this.isBindOnNewForm()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Binding to new form");
            }
            binder.bind((PortletRequest)request);
            this.onBindOnNewForm(request, command, errors);
        }
        return errors;
    }

    protected void onBindOnNewForm(RenderRequest request, Object command, BindException errors) throws Exception {
        this.onBindOnNewForm(request, command);
    }

    protected void onBindOnNewForm(RenderRequest request, Object command) throws Exception {
    }

    protected final Object getCommand(PortletRequest request) throws Exception {
        if (!this.isSessionForm()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Not a session-form -- using new formBackingObject");
            }
            return this.formBackingObject(request);
        }
        PortletSession session = request.getPortletSession(false);
        if (session == null) {
            throw new PortletSessionRequiredException("Must have session when trying to bind (in session-form mode)");
        }
        String formAttrName = this.getFormSessionAttributeName(request);
        Object sessionFormObject = session.getAttribute(formAttrName);
        if (sessionFormObject == null) {
            throw new PortletSessionRequiredException("Form object not found in session (in session-form mode)");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Removing form session attribute [" + formAttrName + "]"));
        }
        session.removeAttribute(formAttrName);
        if (!this.checkCommand(sessionFormObject)) {
            throw new PortletSessionRequiredException("Object found in session does not match commandClass");
        }
        return sessionFormObject;
    }

    protected Object formBackingObject(PortletRequest request) throws Exception {
        return this.createCommand();
    }

    protected abstract ModelAndView showForm(RenderRequest var1, RenderResponse var2, BindException var3) throws Exception;

    protected final ModelAndView showForm(RenderRequest request, BindException errors, String viewName) throws Exception {
        return this.showForm(request, errors, viewName, null);
    }

    protected final ModelAndView showForm(RenderRequest request, BindException errors, String viewName, Map controlModel) throws Exception {
        if (this.isSessionForm()) {
            String formAttrName = this.getFormSessionAttributeName((PortletRequest)request);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Setting form session attribute [" + formAttrName + "] to: " + errors.getTarget()));
            }
            request.getPortletSession().setAttribute(formAttrName, errors.getTarget());
        }
        Map model = errors.getModel();
        Map referenceData = this.referenceData((PortletRequest)request, errors.getTarget(), errors);
        if (referenceData != null) {
            model.putAll(referenceData);
        }
        if (controlModel != null) {
            model.putAll(controlModel);
        }
        return new ModelAndView(viewName, model);
    }

    protected Map referenceData(PortletRequest request, Object command, Errors errors) throws Exception {
        return null;
    }

    protected abstract ModelAndView renderFormSubmission(RenderRequest var1, RenderResponse var2, Object var3, BindException var4) throws Exception;

    protected abstract void processFormSubmission(ActionRequest var1, ActionResponse var2, Object var3, BindException var4) throws Exception;

    protected ModelAndView renderInvalidSubmit(RenderRequest request, RenderResponse response) throws Exception {
        return this.renderFormSubmission(request, response, this.getRenderCommand(request), this.getRenderErrors(request));
    }

    protected void handleInvalidSubmit(ActionRequest request, ActionResponse response) throws Exception {
        this.passRenderParameters(request, response);
        Object command = this.formBackingObject((PortletRequest)request);
        if (command == null) {
            throw new PortletException("Form object returned by formBackingObject() must not be null");
        }
        if (!this.checkCommand(command)) {
            throw new PortletException("Form object returned by formBackingObject() must match commandClass");
        }
        PortletRequestDataBinder binder = this.bindAndValidate((PortletRequest)request, command);
        BindException errors = new BindException(binder.getBindingResult());
        this.processFormSubmission(request, response, command, errors);
        this.setRenderCommandAndErrors(request, command, errors);
    }
}

