/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.support;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.springframework.orm.jpa.EntityManagerPlus;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.orm.jpa.SharedEntityManagerCreator;
import org.springframework.util.Assert;

public class SharedEntityManagerBean
implements FactoryBean,
InitializingBean {
    private EntityManagerFactory target;
    private Class entityManagerInterface;
    private EntityManager shared;

    public void setEntityManagerFactory(EntityManagerFactory target) {
        this.target = target;
    }

    public void setEntityManagerInterface(Class entityManagerInterface) {
        Assert.notNull(entityManagerInterface, "entityManagerInterface must not be null");
        Assert.isAssignable(EntityManager.class, entityManagerInterface);
        this.entityManagerInterface = entityManagerInterface;
    }

    public final void afterPropertiesSet() {
        if (this.target == null) {
            throw new IllegalArgumentException("entityManagerFactory is required");
        }
        Class[] ifcs = null;
        if (this.target instanceof EntityManagerFactoryInfo) {
            JpaDialect jpaDialect;
            EntityManagerFactoryInfo emfInfo = (EntityManagerFactoryInfo)this.target;
            if (this.entityManagerInterface == null) {
                this.entityManagerInterface = emfInfo.getEntityManagerInterface();
            }
            ifcs = (jpaDialect = emfInfo.getJpaDialect()) != null && jpaDialect.supportsEntityManagerPlusOperations() ? new Class[]{this.entityManagerInterface, EntityManagerPlus.class} : new Class[]{this.entityManagerInterface};
        } else {
            if (this.entityManagerInterface == null) {
                this.entityManagerInterface = EntityManager.class;
            }
            ifcs = new Class[]{this.entityManagerInterface};
        }
        this.shared = SharedEntityManagerCreator.createSharedEntityManager(this.target, ifcs);
    }

    public EntityManager getObject() {
        return this.shared;
    }

    public Class getObjectType() {
        return this.entityManagerInterface;
    }

    public boolean isSingleton() {
        return true;
    }
}

