/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo.support;

import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.jdo.PersistenceManagerFactoryUtils;
import org.springframework.orm.jdo.PersistenceManagerHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.portlet.handler.HandlerInterceptorAdapter;

public class PortletOpenPersistenceManagerInViewInterceptor
extends HandlerInterceptorAdapter {
    public static final String PARTICIPATE_SUFFIX = ".PARTICIPATE";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private PersistenceManagerFactory persistenceManagerFactory;

    public void setPersistenceManagerFactory(PersistenceManagerFactory pmf) {
        this.persistenceManagerFactory = pmf;
    }

    public PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.persistenceManagerFactory;
    }

    public boolean preHandle(PortletRequest request, PortletResponse response, Object handler) throws DataAccessException {
        if (TransactionSynchronizationManager.hasResource(this.getPersistenceManagerFactory())) {
            String participateAttributeName = this.getParticipateAttributeName();
            Integer count = (Integer)request.getAttribute(participateAttributeName);
            int newCount = count != null ? count + 1 : 1;
            request.setAttribute(this.getParticipateAttributeName(), (Object)new Integer(newCount));
        } else {
            this.logger.debug((Object)"Opening JDO persistence manager in OpenPersistenceManagerInViewInterceptor");
            PersistenceManager pm = PersistenceManagerFactoryUtils.getPersistenceManager(this.getPersistenceManagerFactory(), true);
            TransactionSynchronizationManager.bindResource(this.getPersistenceManagerFactory(), new PersistenceManagerHolder(pm));
        }
        return true;
    }

    public void afterCompletion(PortletRequest request, PortletResponse response, Object handler, Exception ex) throws DataAccessException {
        String participateAttributeName = this.getParticipateAttributeName();
        Integer count = (Integer)request.getAttribute(participateAttributeName);
        if (count != null) {
            if (count > 1) {
                request.setAttribute(participateAttributeName, (Object)new Integer(count - 1));
            } else {
                request.removeAttribute(participateAttributeName);
            }
        } else {
            PersistenceManagerHolder pmHolder = (PersistenceManagerHolder)TransactionSynchronizationManager.unbindResource(this.getPersistenceManagerFactory());
            this.logger.debug((Object)"Closing JDO persistence manager in OpenPersistenceManagerInViewInterceptor");
            PersistenceManagerFactoryUtils.releasePersistenceManager(pmHolder.getPersistenceManager(), this.getPersistenceManagerFactory());
        }
    }

    protected String getParticipateAttributeName() {
        return this.getPersistenceManagerFactory().toString() + PARTICIPATE_SUFFIX;
    }
}

