/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOverridingClassLoader
extends ClassLoader {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final boolean debug = this.logger.isDebugEnabled();
    private final Set<String> exclusions = new HashSet<String>();
    private final Set<String> inclusions = new HashSet<String>();
    private final Set<String> namesSeen = new HashSet<String>();

    protected AbstractOverridingClassLoader(ClassLoader parent) {
        super(parent);
    }

    public void addClassNameToExcludeFromUndelegation(String className) {
        this.exclusions.add(className);
    }

    public void addClassNameToExplicitlyInclude(String className) {
        this.inclusions.add(className);
    }

    protected boolean excludeFromUndelegation(String name) {
        return this.exclusions.contains(name) || !this.inclusions.contains(name);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (!(name.startsWith("java") || this.namesSeen.contains(name) || this.excludeFromUndelegation(name))) {
            this.namesSeen.add(name);
            String internalName = StringUtils.replace(name, ".", "/") + ".class";
            InputStream is = this.getParent().getResourceAsStream(internalName);
            if (is == null) {
                throw new ClassNotFoundException(name);
            }
            try {
                byte[] bytes = FileCopyUtils.copyToByteArray(is);
                byte[] transformed = this.transformIfNecessary(name, internalName, bytes);
                return this.defineClass(name, transformed, 0, transformed.length);
            }
            catch (IOException ex) {
                throw new ClassNotFoundException("Cannot load resource for class [" + name + "]", ex);
            }
        }
        return super.loadClass(name);
    }

    protected abstract byte[] transformIfNecessary(String var1, String var2, byte[] var3);
}

