/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import org.springframework.beans.factory.ParseState;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.ComponentDefinition;
import org.springframework.beans.factory.support.Location;
import org.springframework.beans.factory.support.Problem;
import org.springframework.beans.factory.support.ProblemReporter;
import org.springframework.beans.factory.support.ReaderEventListener;
import org.springframework.beans.factory.support.SourceExtractor;
import org.springframework.core.io.Resource;

public class ReaderContext {
    private final Resource resource;
    private final ProblemReporter problemReporter;
    private final ReaderEventListener eventListener;
    private final BeanDefinitionReader reader;
    private final SourceExtractor sourceExtractor;

    public ReaderContext(BeanDefinitionReader reader, Resource resource, ProblemReporter problemReporter, ReaderEventListener eventListener, SourceExtractor sourceExtractor) {
        this.reader = reader;
        this.resource = resource;
        this.problemReporter = problemReporter;
        this.eventListener = eventListener;
        this.sourceExtractor = sourceExtractor;
    }

    public BeanDefinitionReader getReader() {
        return this.reader;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void error(String message, Object source) {
        this.error(message, source, null, null);
    }

    public void error(String message, Object source, ParseState parseState) {
        this.error(message, source, parseState, null);
    }

    public void error(String message, Object source, ParseState parseState, Throwable cause) {
        Location location = new Location(this.getResource(), source);
        this.problemReporter.error(new Problem(message, parseState, cause, location));
    }

    public void warning(String message, Object source) {
        this.warning(message, source, null, null);
    }

    public void warning(String message, Object source, ParseState parseState) {
        this.warning(message, source, parseState, null);
    }

    public void warning(String message, Object source, ParseState parseState, Throwable cause) {
        Location location = new Location(this.getResource(), source);
        this.problemReporter.warning(new Problem(message, parseState, cause, location));
    }

    public void fireComponentRegistered(ComponentDefinition componentDefinition) {
        this.eventListener.componentRegistered(componentDefinition);
    }

    public void fireAliasRegistered(String targetBeanName, String alias, Object source) {
        this.eventListener.aliasRegistered(targetBeanName, alias, source);
    }

    public void fireImportProcessed(String importedResource, Object source) {
        this.eventListener.importProcessed(importedResource, source);
    }

    public SourceExtractor getSourceExtractor() {
        return this.sourceExtractor;
    }
}

