/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.config;

import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.core.Conventions;
import org.springframework.transaction.config.AnnotationDrivenBeanDefinitionParser;
import org.springframework.transaction.config.TxAdviceBeanDefinitionParser;
import org.springframework.util.ClassUtils;

public class TxNamespaceHandler
extends NamespaceHandlerSupport {
    public static final String TRANSACTION_MANAGER_ATTRIBUTE = "transaction-manager";
    public static final String TRANSACTION_MANAGER_PROPERTY = Conventions.attributeNameToPropertyName("transaction-manager");
    public static final String TRANSACTION_ATTRIBUTE_SOURCE = "transactionAttributeSource";
    public static final String ANNOTATION_SOURCE_CLASS_NAME = "org.springframework.transaction.annotation.AnnotationTransactionAttributeSource";

    public void init() {
        this.registerBeanDefinitionParser("advice", new TxAdviceBeanDefinitionParser());
        this.registerBeanDefinitionParser("annotation-driven", new AnnotationDrivenBeanDefinitionParser());
    }

    public static Class getAnnotationSourceClass() {
        try {
            return ClassUtils.forName(ANNOTATION_SOURCE_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to locate AnnotationTransactionAttributeSource. Are you running on Java 1.5?");
        }
    }
}

