/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanEntry;
import org.springframework.beans.factory.ConstructorArgEntry;
import org.springframework.beans.factory.ParseState;
import org.springframework.beans.factory.PropertyEntry;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.LookupOverride;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedProperties;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.support.MethodOverrides;
import org.springframework.beans.factory.support.ReaderContext;
import org.springframework.beans.factory.support.ReplaceOverride;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.AttributeAccessor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlBeanDefinitionParserHelper {
    public static final String BEANS_NAMESPACE_URI = "http://www.springframework.org/schema/beans";
    public static final String BEAN_NAME_DELIMITERS = ",; ";
    public static final String TRUE_VALUE = "true";
    public static final String DEFAULT_VALUE = "default";
    public static final String DESCRIPTION_ELEMENT = "description";
    public static final String AUTOWIRE_BY_NAME_VALUE = "byName";
    public static final String AUTOWIRE_BY_TYPE_VALUE = "byType";
    public static final String AUTOWIRE_CONSTRUCTOR_VALUE = "constructor";
    public static final String AUTOWIRE_AUTODETECT_VALUE = "autodetect";
    public static final String DEPENDENCY_CHECK_ALL_ATTRIBUTE_VALUE = "all";
    public static final String DEPENDENCY_CHECK_SIMPLE_ATTRIBUTE_VALUE = "simple";
    public static final String DEPENDENCY_CHECK_OBJECTS_ATTRIBUTE_VALUE = "objects";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String BEAN_ELEMENT = "bean";
    public static final String META_ELEMENT = "meta";
    public static final String ID_ATTRIBUTE = "id";
    public static final String PARENT_ATTRIBUTE = "parent";
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String ABSTRACT_ATTRIBUTE = "abstract";
    public static final String SINGLETON_ATTRIBUTE = "singleton";
    public static final String LAZY_INIT_ATTRIBUTE = "lazy-init";
    public static final String AUTOWIRE_ATTRIBUTE = "autowire";
    public static final String AUTOWIRE_CANDIDATE_ATTRIBUTE = "autowire-candidate";
    public static final String DEPENDENCY_CHECK_ATTRIBUTE = "dependency-check";
    public static final String DEPENDS_ON_ATTRIBUTE = "depends-on";
    public static final String INIT_METHOD_ATTRIBUTE = "init-method";
    public static final String DESTROY_METHOD_ATTRIBUTE = "destroy-method";
    public static final String FACTORY_METHOD_ATTRIBUTE = "factory-method";
    public static final String FACTORY_BEAN_ATTRIBUTE = "factory-bean";
    public static final String CONSTRUCTOR_ARG_ELEMENT = "constructor-arg";
    public static final String INDEX_ATTRIBUTE = "index";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String VALUE_TYPE_ATTRIBUTE = "value-type";
    public static final String KEY_TYPE_ATTRIBUTE = "key-type";
    public static final String PROPERTY_ELEMENT = "property";
    public static final String REF_ATTRIBUTE = "ref";
    public static final String VALUE_ATTRIBUTE = "value";
    public static final String LOOKUP_METHOD_ELEMENT = "lookup-method";
    public static final String REPLACED_METHOD_ELEMENT = "replaced-method";
    public static final String REPLACER_ATTRIBUTE = "replacer";
    public static final String ARG_TYPE_ELEMENT = "arg-type";
    public static final String ARG_TYPE_MATCH_ATTRIBUTE = "match";
    public static final String REF_ELEMENT = "ref";
    public static final String IDREF_ELEMENT = "idref";
    public static final String BEAN_REF_ATTRIBUTE = "bean";
    public static final String LOCAL_REF_ATTRIBUTE = "local";
    public static final String PARENT_REF_ATTRIBUTE = "parent";
    public static final String VALUE_ELEMENT = "value";
    public static final String NULL_ELEMENT = "null";
    public static final String LIST_ELEMENT = "list";
    public static final String SET_ELEMENT = "set";
    public static final String MAP_ELEMENT = "map";
    public static final String ENTRY_ELEMENT = "entry";
    public static final String KEY_ELEMENT = "key";
    public static final String KEY_ATTRIBUTE = "key";
    public static final String KEY_REF_ATTRIBUTE = "key-ref";
    public static final String VALUE_REF_ATTRIBUTE = "value-ref";
    public static final String PROPS_ELEMENT = "props";
    public static final String PROP_ELEMENT = "prop";
    public static final String MERGE_ATTRIBUTE = "merge";
    public static final String DEFAULT_LAZY_INIT_ATTRIBUTE = "default-lazy-init";
    public static final String DEFAULT_AUTOWIRE_ATTRIBUTE = "default-autowire";
    public static final String DEFAULT_DEPENDENCY_CHECK_ATTRIBUTE = "default-dependency-check";
    public static final String DEFAULT_INIT_METHOD_ATTRIBUTE = "default-init-method";
    public static final String DEFAULT_DESTROY_METHOD_ATTRIBUTE = "default-destroy-method";
    public static final String DEFAULT_MERGE_ATTRIBUTE = "default-merge";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ParseState parseState = new ParseState();
    private final ReaderContext readerContext;
    private final NamespaceHandlerResolver handlerResolver;
    private String defaultLazyInit;
    private String defaultAutowire;
    private String defaultDependencyCheck;
    private String defaultInitMethod;
    private String defaultDestroyMethod;
    private String defaultMerge;

    public ReaderContext getReaderContext() {
        return this.readerContext;
    }

    public final void setDefaultLazyInit(String defaultLazyInit) {
        this.defaultLazyInit = defaultLazyInit;
    }

    public final String getDefaultLazyInit() {
        return this.defaultLazyInit;
    }

    public final void setDefaultAutowire(String defaultAutowire) {
        this.defaultAutowire = defaultAutowire;
    }

    public final String getDefaultAutowire() {
        return this.defaultAutowire;
    }

    public final void setDefaultDependencyCheck(String defaultDependencyCheck) {
        this.defaultDependencyCheck = defaultDependencyCheck;
    }

    public final String getDefaultDependencyCheck() {
        return this.defaultDependencyCheck;
    }

    public final void setDefaultInitMethod(String defaultInitMethod) {
        this.defaultInitMethod = defaultInitMethod;
    }

    public final String getDefaultInitMethod() {
        return this.defaultInitMethod;
    }

    public final void setDefaultDestroyMethod(String defaultDestroyMethod) {
        this.defaultDestroyMethod = defaultDestroyMethod;
    }

    public final String getDefaultDestroyMethod() {
        return this.defaultDestroyMethod;
    }

    public final void setDefaultMerge(String defaultMerge) {
        this.defaultMerge = defaultMerge;
    }

    public final String getDefaultMerge() {
        return this.defaultMerge;
    }

    public XmlBeanDefinitionParserHelper(ReaderContext readerContext, NamespaceHandlerResolver handlerResolver) {
        Assert.notNull(readerContext, "'readerContext' cannot be null.");
        Assert.notNull(handlerResolver, "'handlerResolver' cannot be null.");
        this.readerContext = readerContext;
        this.handlerResolver = handlerResolver;
    }

    public void initDefaults(Element root) {
        this.setDefaultLazyInit(root.getAttribute(DEFAULT_LAZY_INIT_ATTRIBUTE));
        this.setDefaultAutowire(root.getAttribute(DEFAULT_AUTOWIRE_ATTRIBUTE));
        this.setDefaultDependencyCheck(root.getAttribute(DEFAULT_DEPENDENCY_CHECK_ATTRIBUTE));
        if (root.hasAttribute(DEFAULT_INIT_METHOD_ATTRIBUTE)) {
            this.setDefaultInitMethod(root.getAttribute(DEFAULT_INIT_METHOD_ATTRIBUTE));
        }
        if (root.hasAttribute(DEFAULT_DESTROY_METHOD_ATTRIBUTE)) {
            this.setDefaultDestroyMethod(root.getAttribute(DEFAULT_DESTROY_METHOD_ATTRIBUTE));
        }
        this.setDefaultMerge(root.getAttribute(DEFAULT_MERGE_ATTRIBUTE));
    }

    public BeanDefinitionHolder parseBeanDefinitionElement(Element ele, boolean isInnerBean) {
        BeanDefinition beanDefinition;
        String beanName;
        String id = ele.getAttribute(ID_ATTRIBUTE);
        String nameAttr = ele.getAttribute(NAME_ATTRIBUTE);
        ArrayList<String> aliases = new ArrayList<String>();
        if (StringUtils.hasLength(nameAttr)) {
            String[] nameArr = StringUtils.tokenizeToStringArray(nameAttr, BEAN_NAME_DELIMITERS);
            aliases.addAll(Arrays.asList(nameArr));
        }
        if (!StringUtils.hasText(beanName = id) && !aliases.isEmpty()) {
            beanName = (String)aliases.remove(0);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No XML 'id' specified - using '" + beanName + "' as bean name and " + aliases + " as aliases"));
            }
        }
        if ((beanDefinition = this.parseBeanDefinitionElement(ele, beanName)) != null) {
            if (!StringUtils.hasText(beanName) && beanDefinition instanceof AbstractBeanDefinition) {
                beanName = BeanDefinitionReaderUtils.generateBeanName((AbstractBeanDefinition)beanDefinition, this.getReaderContext().getReader().getBeanFactory(), isInnerBean);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Neither XML 'id' nor 'name' specified - using generated bean name [" + beanName + "]"));
                }
            }
            String[] aliasesArray = StringUtils.toStringArray(aliases);
            return new BeanDefinitionHolder(beanDefinition, beanName, aliasesArray);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanDefinition parseBeanDefinitionElement(Element ele, String beanName) {
        String className = null;
        if (ele.hasAttribute(CLASS_ATTRIBUTE)) {
            className = ele.getAttribute(CLASS_ATTRIBUTE);
        }
        String parent = null;
        if (ele.hasAttribute("parent")) {
            parent = ele.getAttribute("parent");
        }
        try {
            String lazyInit;
            String dependencyCheck;
            this.parseState.push(new BeanEntry(beanName));
            ConstructorArgumentValues cargs = this.parseConstructorArgElements(ele);
            MutablePropertyValues pvs = this.parsePropertyElements(ele);
            AbstractBeanDefinition bd = BeanDefinitionReaderUtils.createBeanDefinition(className, parent, cargs, pvs, this.getReaderContext().getReader().getBeanClassLoader());
            this.parseMetaElements(ele, bd);
            bd.setSource(this.extractSource(ele));
            if (ele.hasAttribute(DEPENDS_ON_ATTRIBUTE)) {
                String dependsOn = ele.getAttribute(DEPENDS_ON_ATTRIBUTE);
                bd.setDependsOn(StringUtils.tokenizeToStringArray(dependsOn, BEAN_NAME_DELIMITERS));
            }
            if (ele.hasAttribute(FACTORY_METHOD_ATTRIBUTE)) {
                bd.setFactoryMethodName(ele.getAttribute(FACTORY_METHOD_ATTRIBUTE));
            }
            if (ele.hasAttribute(FACTORY_BEAN_ATTRIBUTE)) {
                bd.setFactoryBeanName(ele.getAttribute(FACTORY_BEAN_ATTRIBUTE));
            }
            if (DEFAULT_VALUE.equals(dependencyCheck = ele.getAttribute(DEPENDENCY_CHECK_ATTRIBUTE))) {
                dependencyCheck = this.getDefaultDependencyCheck();
            }
            bd.setDependencyCheck(this.getDependencyCheck(dependencyCheck));
            String autowire = ele.getAttribute(AUTOWIRE_ATTRIBUTE);
            if (DEFAULT_VALUE.equals(autowire)) {
                autowire = this.getDefaultAutowire();
            }
            bd.setAutowireMode(this.getAutowireMode(autowire));
            if (ele.hasAttribute(INIT_METHOD_ATTRIBUTE)) {
                String initMethodName = ele.getAttribute(INIT_METHOD_ATTRIBUTE);
                if (!"".equals(initMethodName)) {
                    bd.setInitMethodName(initMethodName);
                }
            } else if (this.getDefaultInitMethod() != null) {
                bd.setInitMethodName(this.getDefaultInitMethod());
                bd.setEnforceInitMethod(false);
            }
            if (ele.hasAttribute(DESTROY_METHOD_ATTRIBUTE)) {
                String destroyMethodName = ele.getAttribute(DESTROY_METHOD_ATTRIBUTE);
                if (!"".equals(destroyMethodName)) {
                    bd.setDestroyMethodName(destroyMethodName);
                }
            } else if (this.getDefaultDestroyMethod() != null) {
                bd.setDestroyMethodName(this.getDefaultDestroyMethod());
                bd.setEnforceDestroyMethod(false);
            }
            this.parseLookupOverrideSubElements(ele, bd.getMethodOverrides());
            this.parseReplacedMethodSubElements(ele, bd.getMethodOverrides());
            bd.setResourceDescription(this.getReaderContext().getResource().getDescription());
            if (ele.hasAttribute(ABSTRACT_ATTRIBUTE)) {
                bd.setAbstract(TRUE_VALUE.equals(ele.getAttribute(ABSTRACT_ATTRIBUTE)));
            }
            if (ele.hasAttribute(SINGLETON_ATTRIBUTE)) {
                bd.setSingleton(TRUE_VALUE.equals(ele.getAttribute(SINGLETON_ATTRIBUTE)));
            }
            if (DEFAULT_VALUE.equals(lazyInit = ele.getAttribute(LAZY_INIT_ATTRIBUTE)) && bd.isSingleton()) {
                lazyInit = this.getDefaultLazyInit();
            }
            bd.setLazyInit(TRUE_VALUE.equals(lazyInit));
            bd.setAutowireCandidate(TRUE_VALUE.equals(ele.getAttribute(AUTOWIRE_CANDIDATE_ATTRIBUTE)));
            AbstractBeanDefinition abstractBeanDefinition = bd;
            return abstractBeanDefinition;
        }
        catch (ClassNotFoundException ex) {
            this.error("Bean class [" + className + "] not found", ele, ex);
        }
        catch (NoClassDefFoundError err) {
            this.error("Class that bean class [" + className + "] depends on not found", ele, err);
        }
        catch (Throwable ex) {
            this.error("Unexpected failure during bean definition parsing", ele, ex);
        }
        finally {
            this.parseState.pop();
        }
        return null;
    }

    public void parseMetaElements(Element ele, AttributeAccessor attributeAccessor) {
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element) || !DomUtils.nodeNameEquals(node, META_ELEMENT)) continue;
            Element metaElement = (Element)node;
            String key = metaElement.getAttribute("key");
            String value = metaElement.getAttribute("value");
            attributeAccessor.setAttribute(key, value);
        }
    }

    private Object extractSource(Element ele) {
        return this.getReaderContext().getSourceExtractor().extract(ele);
    }

    public int getDependencyCheck(String att) {
        int dependencyCheckCode = 0;
        if (DEPENDENCY_CHECK_ALL_ATTRIBUTE_VALUE.equals(att)) {
            dependencyCheckCode = 3;
        } else if (DEPENDENCY_CHECK_SIMPLE_ATTRIBUTE_VALUE.equals(att)) {
            dependencyCheckCode = 2;
        } else if (DEPENDENCY_CHECK_OBJECTS_ATTRIBUTE_VALUE.equals(att)) {
            dependencyCheckCode = 1;
        }
        return dependencyCheckCode;
    }

    public int getAutowireMode(String att) {
        int autowire = 0;
        if (AUTOWIRE_BY_NAME_VALUE.equals(att)) {
            autowire = 1;
        } else if (AUTOWIRE_BY_TYPE_VALUE.equals(att)) {
            autowire = 2;
        } else if (AUTOWIRE_CONSTRUCTOR_VALUE.equals(att)) {
            autowire = 3;
        } else if (AUTOWIRE_AUTODETECT_VALUE.equals(att)) {
            autowire = 4;
        }
        return autowire;
    }

    public ConstructorArgumentValues parseConstructorArgElements(Element beanEle) {
        NodeList nl = beanEle.getChildNodes();
        ConstructorArgumentValues cargs = new ConstructorArgumentValues();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element) || !DomUtils.nodeNameEquals(node, CONSTRUCTOR_ARG_ELEMENT)) continue;
            this.parseConstructorArgElement((Element)node, cargs);
        }
        return cargs;
    }

    public MutablePropertyValues parsePropertyElements(Element beanEle) {
        NodeList nl = beanEle.getChildNodes();
        MutablePropertyValues pvs = new MutablePropertyValues();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element) || !DomUtils.nodeNameEquals(node, PROPERTY_ELEMENT)) continue;
            this.parsePropertyElement((Element)node, pvs);
        }
        return pvs;
    }

    public void parseLookupOverrideSubElements(Element beanEle, MethodOverrides overrides) {
        NodeList nl = beanEle.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element) || !DomUtils.nodeNameEquals(node, LOOKUP_METHOD_ELEMENT)) continue;
            Element ele = (Element)node;
            String methodName = ele.getAttribute(NAME_ATTRIBUTE);
            String beanRef = ele.getAttribute("bean");
            LookupOverride override = new LookupOverride(methodName, beanRef);
            override.setSource(this.extractSource(ele));
            overrides.addOverride(override);
        }
    }

    public void parseReplacedMethodSubElements(Element beanEle, MethodOverrides overrides) {
        NodeList nl = beanEle.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element) || !DomUtils.nodeNameEquals(node, REPLACED_METHOD_ELEMENT)) continue;
            Element replacedMethodEle = (Element)node;
            String name = replacedMethodEle.getAttribute(NAME_ATTRIBUTE);
            String callback = replacedMethodEle.getAttribute(REPLACER_ATTRIBUTE);
            ReplaceOverride replaceOverride = new ReplaceOverride(name, callback);
            List argTypeEles = DomUtils.getChildElementsByTagName(replacedMethodEle, ARG_TYPE_ELEMENT);
            Iterator it = argTypeEles.iterator();
            while (it.hasNext()) {
                Element argTypeEle = (Element)it.next();
                replaceOverride.addTypeIdentifier(argTypeEle.getAttribute(ARG_TYPE_MATCH_ATTRIBUTE));
            }
            replaceOverride.setSource(this.extractSource(replacedMethodEle));
            overrides.addOverride(replaceOverride);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseConstructorArgElement(Element ele, ConstructorArgumentValues cargs) {
        String indexAttr = ele.getAttribute(INDEX_ATTRIBUTE);
        String typeAttr = ele.getAttribute(TYPE_ATTRIBUTE);
        if (StringUtils.hasLength(indexAttr)) {
            try {
                int index = Integer.parseInt(indexAttr);
                if (index < 0) {
                    this.error("'index' cannot be lower than 0", ele);
                }
                try {
                    this.parseState.push(new ConstructorArgEntry(index));
                    Object val = this.parsePropertyValue(ele, null);
                    if (StringUtils.hasLength(typeAttr)) {
                        cargs.addIndexedArgumentValue(index, val, typeAttr);
                    } else {
                        cargs.addIndexedArgumentValue(index, val);
                    }
                }
                finally {
                    this.parseState.pop();
                }
            }
            catch (NumberFormatException ex) {
                this.error("Attribute 'index' of tag 'constructor-arg' must be an integer", ele);
            }
        } else {
            try {
                this.parseState.push(new ConstructorArgEntry());
                Object val = this.parsePropertyValue(ele, null);
                if (StringUtils.hasLength(typeAttr)) {
                    cargs.addGenericArgumentValue(val, typeAttr);
                } else {
                    cargs.addGenericArgumentValue(val);
                }
            }
            finally {
                this.parseState.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parsePropertyElement(Element ele, MutablePropertyValues pvs) {
        String propertyName = ele.getAttribute(NAME_ATTRIBUTE);
        if (!StringUtils.hasLength(propertyName)) {
            this.error("Tag 'property' must have a 'name' attribute", ele);
            return;
        }
        this.parseState.push(new PropertyEntry(propertyName));
        try {
            if (pvs.contains(propertyName)) {
                this.error("Multiple 'property' definitions for property '" + propertyName + "'", ele);
                return;
            }
            Object val = this.parsePropertyValue(ele, propertyName);
            PropertyValue pv = new PropertyValue(propertyName, val);
            this.parseMetaElements(ele, pv);
            pv.setSource(this.extractSource(ele));
            pvs.addPropertyValue(pv);
        }
        finally {
            this.parseState.pop();
        }
    }

    public Object parsePropertyValue(Element ele, String propertyName) {
        String elementName = propertyName != null ? "<property> element for property '" + propertyName + "'" : "<constructor-arg> element";
        NodeList nl = ele.getChildNodes();
        Element subElement = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!(nl.item(i) instanceof Element)) continue;
            Element candidateEle = (Element)nl.item(i);
            if (!this.isDefaultNamespace(candidateEle.getNamespaceURI())) {
                return this.parseNestedCustomElement(candidateEle);
            }
            if (DESCRIPTION_ELEMENT.equals(candidateEle.getTagName())) continue;
            if (subElement != null && !META_ELEMENT.equals(subElement.getTagName())) {
                this.error(elementName + " must not contain more than one sub-element", ele);
            }
            subElement = candidateEle;
        }
        boolean hasRefAttribute = ele.hasAttribute("ref");
        boolean hasValueAttribute = ele.hasAttribute("value");
        if (hasRefAttribute && hasValueAttribute || (hasRefAttribute || hasValueAttribute) && subElement != null) {
            this.error(elementName + " is only allowed to contain either 'ref' attribute OR 'value' attribute OR sub-element", ele);
        }
        if (hasRefAttribute) {
            String refName = ele.getAttribute("ref");
            if (!StringUtils.hasText(refName)) {
                this.error(elementName + " contains empty 'ref' attribute", ele);
            }
            return new RuntimeBeanReference(refName);
        }
        if (hasValueAttribute) {
            return ele.getAttribute("value");
        }
        if (subElement == null) {
            this.error(elementName + " must specify a ref or value", ele);
        }
        return this.parsePropertySubElement(subElement);
    }

    public Object parsePropertySubElement(Element ele) {
        return this.parsePropertySubElement(ele, null);
    }

    public Object parsePropertySubElement(Element ele, String defaultTypeClassName) {
        if (ele.getTagName().equals("bean")) {
            return this.parseBeanDefinitionElement(ele, true);
        }
        if (ele.getTagName().equals("ref")) {
            String refName = ele.getAttribute("bean");
            boolean toParent = false;
            if (!StringUtils.hasLength(refName) && !StringUtils.hasLength(refName = ele.getAttribute(LOCAL_REF_ATTRIBUTE))) {
                refName = ele.getAttribute("parent");
                toParent = true;
                if (!StringUtils.hasLength(refName)) {
                    this.error("'bean', 'local' or 'parent' is required for <ref> element", ele);
                }
            }
            if (!StringUtils.hasText(refName)) {
                this.error("<ref> element contains empty target attribute", ele);
            }
            return new RuntimeBeanReference(refName, toParent);
        }
        if (ele.getTagName().equals(IDREF_ELEMENT)) {
            String beanRef = ele.getAttribute("bean");
            if (!StringUtils.hasLength(beanRef) && !StringUtils.hasLength(beanRef = ele.getAttribute(LOCAL_REF_ATTRIBUTE))) {
                this.error("Either 'bean' or 'local' is required for <idref> element", ele);
            }
            return beanRef;
        }
        if (ele.getTagName().equals("value")) {
            String value = DomUtils.getTextValue(ele);
            String typeClassName = ele.getAttribute(TYPE_ATTRIBUTE);
            if (!StringUtils.hasText(typeClassName)) {
                typeClassName = defaultTypeClassName;
            }
            if (StringUtils.hasText(typeClassName)) {
                try {
                    Class typeClass = ClassUtils.forName(typeClassName, this.getReaderContext().getReader().getBeanClassLoader());
                    return new TypedStringValue(value, typeClass);
                }
                catch (ClassNotFoundException ex) {
                    this.error("Type class [" + typeClassName + "] not found for <value> element", ele, ex);
                }
            }
            return value;
        }
        if (ele.getTagName().equals(NULL_ELEMENT)) {
            return null;
        }
        if (ele.getTagName().equals(LIST_ELEMENT)) {
            return this.parseListElement(ele);
        }
        if (ele.getTagName().equals(SET_ELEMENT)) {
            return this.parseSetElement(ele);
        }
        if (ele.getTagName().equals(MAP_ELEMENT)) {
            return this.parseMapElement(ele);
        }
        if (ele.getTagName().equals(PROPS_ELEMENT)) {
            return this.parsePropsElement(ele);
        }
        this.error("Unknown property sub-element: [" + ele.getTagName() + "]", ele);
        return null;
    }

    public List parseListElement(Element collectionEle) {
        String defaultTypeClassName = collectionEle.getAttribute(VALUE_TYPE_ATTRIBUTE);
        NodeList nl = collectionEle.getChildNodes();
        ManagedList list = new ManagedList(nl.getLength());
        list.setSource(this.extractSource(collectionEle));
        list.setMergeEnabled(this.parseMergeAttribute(collectionEle));
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!(nl.item(i) instanceof Element)) continue;
            Element ele = (Element)nl.item(i);
            list.add(this.parsePropertySubElement(ele, defaultTypeClassName));
        }
        return list;
    }

    public Set parseSetElement(Element collectionEle) {
        String defaultTypeClassName = collectionEle.getAttribute(VALUE_TYPE_ATTRIBUTE);
        NodeList nl = collectionEle.getChildNodes();
        ManagedSet set = new ManagedSet(nl.getLength());
        set.setSource(this.extractSource(collectionEle));
        set.setMergeEnabled(this.parseMergeAttribute(collectionEle));
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!(nl.item(i) instanceof Element)) continue;
            Element ele = (Element)nl.item(i);
            set.add(this.parsePropertySubElement(ele, defaultTypeClassName));
        }
        return set;
    }

    public Map parseMapElement(Element mapEle) {
        String defaultKeyTypeClassName = mapEle.getAttribute(KEY_TYPE_ATTRIBUTE);
        String defaultValueTypeClassName = mapEle.getAttribute(VALUE_TYPE_ATTRIBUTE);
        List entryEles = DomUtils.getChildElementsByTagName(mapEle, ENTRY_ELEMENT);
        ManagedMap map = new ManagedMap(entryEles.size());
        map.setMergeEnabled(this.parseMergeAttribute(mapEle));
        map.setSource(this.extractSource(mapEle));
        Iterator it = entryEles.iterator();
        while (it.hasNext()) {
            Element entryEle = (Element)it.next();
            NodeList entrySubNodes = entryEle.getChildNodes();
            Element keyEle = null;
            Element valueEle = null;
            for (int j = 0; j < entrySubNodes.getLength(); ++j) {
                if (!(entrySubNodes.item(j) instanceof Element)) continue;
                Element candidateEle = (Element)entrySubNodes.item(j);
                if (candidateEle.getTagName().equals("key")) {
                    if (keyEle != null) {
                        this.error("<entry> element is only allowed to contain one <key> sub-element", entryEle);
                    }
                    keyEle = candidateEle;
                    continue;
                }
                if (valueEle != null) {
                    this.error("<entry> element must not contain more than one value sub-element", entryEle);
                }
                valueEle = candidateEle;
            }
            Object key = null;
            boolean hasKeyAttribute = entryEle.hasAttribute("key");
            boolean hasKeyRefAttribute = entryEle.hasAttribute(KEY_REF_ATTRIBUTE);
            if (hasKeyAttribute && hasKeyRefAttribute || (hasKeyAttribute || hasKeyRefAttribute) && keyEle != null) {
                this.error("<entry> element is only allowed to contain either a 'key' attribute OR a 'key-ref' attribute OR a <key> sub-element", entryEle);
            }
            if (hasKeyAttribute) {
                key = this.extractTypedStringValueIfNecessary(mapEle, entryEle.getAttribute("key"), defaultKeyTypeClassName);
            } else if (hasKeyRefAttribute) {
                String refName = entryEle.getAttribute(KEY_REF_ATTRIBUTE);
                if (!StringUtils.hasText(refName)) {
                    this.error("<entry> element contains empty 'key-ref' attribute", entryEle);
                }
                key = new RuntimeBeanReference(refName);
            } else if (keyEle != null) {
                key = this.parseKeyElement(keyEle, defaultKeyTypeClassName);
            } else {
                this.error("<entry> element must specify a key", entryEle);
            }
            Object value = null;
            boolean hasValueAttribute = entryEle.hasAttribute("value");
            boolean hasValueRefAttribute = entryEle.hasAttribute(VALUE_REF_ATTRIBUTE);
            if (hasValueAttribute && hasValueRefAttribute || (hasValueAttribute || hasValueRefAttribute) && valueEle != null) {
                this.error("<entry> element is only allowed to contain either 'value' attribute OR 'value-ref' attribute OR <value> sub-element", entryEle);
            }
            if (hasValueAttribute) {
                value = this.extractTypedStringValueIfNecessary(mapEle, entryEle.getAttribute("value"), defaultValueTypeClassName);
            } else if (hasValueRefAttribute) {
                String refName = entryEle.getAttribute(VALUE_REF_ATTRIBUTE);
                if (!StringUtils.hasText(refName)) {
                    this.error("<entry> element contains empty 'value-ref' attribute", entryEle);
                }
                value = new RuntimeBeanReference(refName);
            } else if (valueEle != null) {
                value = this.parsePropertySubElement(valueEle, defaultValueTypeClassName);
            } else {
                this.error("<entry> element must specify a value", entryEle);
            }
            map.put(key, value);
        }
        return map;
    }

    private Object extractTypedStringValueIfNecessary(Element mapElement, String attributeValue, String defaultTypeClassName) {
        if (!StringUtils.hasText(defaultTypeClassName)) {
            return attributeValue;
        }
        Class type = null;
        try {
            type = ClassUtils.forName(defaultTypeClassName, this.getReaderContext().getReader().getBeanClassLoader());
        }
        catch (ClassNotFoundException e) {
            this.error("Unable to load class '" + defaultTypeClassName + "' for Map key/value type.", mapElement, e);
            return null;
        }
        return new TypedStringValue(attributeValue, type);
    }

    public Object parseKeyElement(Element keyEle, String defaultKeyTypeClassName) {
        NodeList nl = keyEle.getChildNodes();
        Element subElement = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!(nl.item(i) instanceof Element)) continue;
            Element candidateEle = (Element)nl.item(i);
            if (subElement != null) {
                this.error("<key> element must not contain more than one value sub-element", keyEle);
            }
            subElement = candidateEle;
        }
        return this.parsePropertySubElement(subElement, defaultKeyTypeClassName);
    }

    public Properties parsePropsElement(Element propsEle) {
        ManagedProperties props = new ManagedProperties();
        props.setSource(this.extractSource(propsEle));
        props.setMergeEnabled(this.parseMergeAttribute(propsEle));
        List propEles = DomUtils.getChildElementsByTagName(propsEle, PROP_ELEMENT);
        Iterator it = propEles.iterator();
        while (it.hasNext()) {
            Element propEle = (Element)it.next();
            String key = propEle.getAttribute("key");
            String value = DomUtils.getTextValue(propEle).trim();
            props.setProperty(key, value);
        }
        return props;
    }

    public boolean parseMergeAttribute(Element collectionElement) {
        String value = collectionElement.getAttribute(MERGE_ATTRIBUTE);
        if (DEFAULT_VALUE.equals(value)) {
            value = this.getDefaultMerge();
        }
        return TRUE_VALUE.equals(value);
    }

    public BeanDefinition parseCustomElement(Element ele, boolean nested) {
        String namespaceUri = ele.getNamespaceURI();
        NamespaceHandler handler = this.handlerResolver.resolve(namespaceUri);
        if (handler == null) {
            this.getReaderContext().error("Unable to locate NamespaceHandler for namespace [" + namespaceUri + "].", ele);
            return null;
        }
        BeanDefinitionParser parser = handler.findParserForElement(ele);
        return parser.parse(ele, new ParserContext(this.getReaderContext(), this, nested));
    }

    public BeanDefinitionHolder decorateBeanDefinitionIfRequired(Element element, BeanDefinitionHolder definitionHolder) {
        BeanDefinitionHolder finalDefinition = definitionHolder;
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            String uri = node.getNamespaceURI();
            if (node.getNodeType() != 1 || this.isDefaultNamespace(uri)) continue;
            Element childElement = (Element)node;
            NamespaceHandler handler = this.handlerResolver.resolve(uri);
            BeanDefinitionDecorator decorator = handler.findDecoratorForElement(childElement);
            finalDefinition = decorator.decorate(childElement, finalDefinition, new ParserContext(this.getReaderContext(), this, false));
        }
        return finalDefinition;
    }

    public boolean isDefaultNamespace(String namespaceUri) {
        return !StringUtils.hasLength(namespaceUri) || BEANS_NAMESPACE_URI.equals(namespaceUri);
    }

    private Object parseNestedCustomElement(Element candidateEle) {
        BeanDefinition innerDefinition = this.parseCustomElement(candidateEle, true);
        if (innerDefinition == null) {
            this.error("Incorrect usage of element '" + candidateEle.getNodeName() + "' in a nested manner. This tag cannot be used nested inside <property>.", candidateEle);
            return null;
        }
        return innerDefinition;
    }

    private void error(String message, Object source) {
        this.getReaderContext().error(message, source, this.parseState.snapshot());
    }

    private void error(String message, Object source, Throwable cause) {
        this.getReaderContext().error(message, source, this.parseState.snapshot(), cause);
    }
}

