/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class DefaultNamespaceHandlerResolver
implements NamespaceHandlerResolver {
    private static final String SPRING_HANDLER_MAPPINGS_LOCATION = "META-INF/spring.handlers";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String handlerMappingsLocation = "META-INF/spring.handlers";
    private Map handlerMappings;
    private ClassLoader classLoader;
    static /* synthetic */ Class class$org$springframework$beans$factory$xml$NamespaceHandler;

    public DefaultNamespaceHandlerResolver(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.initHandlerMappings();
    }

    public DefaultNamespaceHandlerResolver(String handlerMappingsLocation, ClassLoader classLoader) {
        Assert.notNull(handlerMappingsLocation, "'handlerMappingsLocation' cannot be null");
        this.handlerMappingsLocation = handlerMappingsLocation;
        this.classLoader = classLoader;
        this.initHandlerMappings();
    }

    private void initHandlerMappings() {
        Properties mappings = this.loadMappings();
        this.handlerMappings = new HashMap(mappings.size());
        Enumeration<?> en = mappings.propertyNames();
        while (en.hasMoreElements()) {
            String namespaceUri = (String)en.nextElement();
            String className = mappings.getProperty(namespaceUri);
            try {
                Class handlerClass = ClassUtils.forName(className);
                if (!(class$org$springframework$beans$factory$xml$NamespaceHandler == null ? DefaultNamespaceHandlerResolver.class$("org.springframework.beans.factory.xml.NamespaceHandler") : class$org$springframework$beans$factory$xml$NamespaceHandler).isAssignableFrom(handlerClass)) {
                    throw new IllegalArgumentException("Class [" + className + "] does not implement the NamespaceHandler interface");
                }
                NamespaceHandler namespaceHandler = (NamespaceHandler)BeanUtils.instantiateClass(handlerClass);
                namespaceHandler.init();
                this.handlerMappings.put(namespaceUri, namespaceHandler);
            }
            catch (ClassNotFoundException ex) {
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info((Object)("Ignoring handler [" + className + "]: class not found"));
            }
        }
    }

    private Properties loadMappings() {
        try {
            return PropertiesLoaderUtils.loadAllProperties(this.handlerMappingsLocation, this.classLoader);
        }
        catch (IOException ex) {
            throw new FatalBeanException("Unable to load NamespaceHandler mappings using mapping location [" + this.handlerMappingsLocation + "].", ex);
        }
    }

    public NamespaceHandler resolve(String namespaceUri) {
        NamespaceHandler namespaceHandler = (NamespaceHandler)this.handlerMappings.get(namespaceUri);
        if (namespaceUri == null) {
            throw new IllegalArgumentException("Unable to locate NamespaceHandler for namespace URI [" + namespaceUri + "]");
        }
        return namespaceHandler;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

