/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.util.ClassUtils;

public class ConstructorArgumentValues {
    private final Map indexedArgumentValues = new HashMap();
    private final List genericArgumentValues = new LinkedList();

    public ConstructorArgumentValues() {
    }

    public ConstructorArgumentValues(ConstructorArgumentValues other) {
        this.addArgumentValues(other);
    }

    public void addArgumentValues(ConstructorArgumentValues other) {
        if (other != null) {
            this.genericArgumentValues.addAll(other.genericArgumentValues);
            this.indexedArgumentValues.putAll(other.indexedArgumentValues);
        }
    }

    public void addIndexedArgumentValue(int index, Object value) {
        this.indexedArgumentValues.put(new Integer(index), new ValueHolder(value));
    }

    public void addIndexedArgumentValue(int index, Object value, String type) {
        this.indexedArgumentValues.put(new Integer(index), new ValueHolder(value, type));
    }

    public ValueHolder getIndexedArgumentValue(int index, Class requiredType) {
        ValueHolder valueHolder = (ValueHolder)this.indexedArgumentValues.get(new Integer(index));
        if (valueHolder != null && (valueHolder.getType() == null || requiredType.getName().equals(valueHolder.getType()))) {
            return valueHolder;
        }
        return null;
    }

    public Map getIndexedArgumentValues() {
        return this.indexedArgumentValues;
    }

    public void addGenericArgumentValue(Object value) {
        this.genericArgumentValues.add(new ValueHolder(value));
    }

    public void addGenericArgumentValue(Object value, String type) {
        this.genericArgumentValues.add(new ValueHolder(value, type));
    }

    public ValueHolder getGenericArgumentValue(Class requiredType) {
        return this.getGenericArgumentValue(requiredType, null);
    }

    public ValueHolder getGenericArgumentValue(Class requiredType, Set usedValueHolders) {
        Iterator it = this.genericArgumentValues.iterator();
        while (it.hasNext()) {
            ValueHolder valueHolder = (ValueHolder)it.next();
            if (usedValueHolders != null && usedValueHolders.contains(valueHolder) || !(requiredType != null ? (valueHolder.getType() != null ? valueHolder.getType().equals(requiredType.getName()) : ClassUtils.isAssignableValue(requiredType, valueHolder.getValue())) : valueHolder.getType() == null)) continue;
            return valueHolder;
        }
        return null;
    }

    public List getGenericArgumentValues() {
        return this.genericArgumentValues;
    }

    public ValueHolder getArgumentValue(int index, Class requiredType) {
        return this.getArgumentValue(index, requiredType, null);
    }

    public ValueHolder getArgumentValue(int index, Class requiredType, Set usedValueHolders) {
        ValueHolder valueHolder = this.getIndexedArgumentValue(index, requiredType);
        if (valueHolder == null) {
            valueHolder = this.getGenericArgumentValue(requiredType, usedValueHolders);
        }
        return valueHolder;
    }

    public int getArgumentCount() {
        return this.indexedArgumentValues.size() + this.genericArgumentValues.size();
    }

    public boolean isEmpty() {
        return this.indexedArgumentValues.isEmpty() && this.genericArgumentValues.isEmpty();
    }

    public void clear() {
        this.indexedArgumentValues.clear();
        this.genericArgumentValues.clear();
    }

    public static class ValueHolder {
        private Object value;
        private String type;

        private ValueHolder(Object value) {
            this.value = value;
        }

        private ValueHolder(Object value, String type) {
            this.value = value;
            this.type = type;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

