/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.annotation;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private Class<? extends Annotation> requiredAnnotationType = Required.class;

    public void setRequiredAnnotationType(Class<? extends Annotation> requiredAnnotationType) {
        Assert.notNull(requiredAnnotationType, "'requiredAnnotationType' cannot be null");
        this.requiredAnnotationType = requiredAnnotationType;
    }

    @Override
    public final void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] beanDefinitionNames;
        for (String beanDefinitionName : beanDefinitionNames = beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanDefinitionName);
            this.processBeanDefinition(beanDefinition, beanDefinitionName);
        }
    }

    protected boolean isRequired(PropertyDescriptor propertyDescriptor) {
        Method setter = propertyDescriptor.getWriteMethod();
        return setter != null && setter.getAnnotation(this.requiredAnnotationType) != null;
    }

    private void processBeanDefinition(BeanDefinition beanDefinition, String beanDefinitionName) {
        Class targetType = ((AbstractBeanDefinition)beanDefinition).getBeanClass();
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(targetType);
        ArrayList<String> invalidProperties = new ArrayList<String>();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (!this.isRequired(propertyDescriptor) || !this.hasNotBeenDefined(propertyDescriptor, beanDefinition)) continue;
            invalidProperties.add(propertyDescriptor.getName());
        }
        if (!invalidProperties.isEmpty()) {
            throw new IllegalArgumentException(this.createExceptionMessage(invalidProperties, beanDefinitionName));
        }
    }

    private boolean hasNotBeenDefined(PropertyDescriptor propertyDescriptor, BeanDefinition beanDefinition) {
        return beanDefinition.getPropertyValues().getPropertyValue(propertyDescriptor.getName()) == null;
    }

    private String createExceptionMessage(List<String> invalidProperties, String beanDefinitionName) {
        StringBuilder sb = new StringBuilder();
        int size = invalidProperties.size();
        sb.append(size == 1 ? "Property" : "Properties");
        for (int i = 0; i < size; ++i) {
            String propertyName = invalidProperties.get(i);
            if (i > 0) {
                if (i == size - 1) {
                    sb.append(" and");
                } else {
                    sb.append(",");
                }
            }
            sb.append(" '");
            sb.append(propertyName);
            sb.append('\'');
        }
        sb.append(size == 1 ? " is required" : " are required");
        sb.append(" for bean '");
        sb.append(beanDefinitionName);
        sb.append("'.");
        return sb.toString();
    }
}

