/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import javax.servlet.jsp.JspException;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.servlet.tags.form.AbstractFormTag;
import org.springframework.web.servlet.tags.form.TagWriter;

public class OptionTag
extends AbstractFormTag {
    private String value;
    private String label;

    public void setValue(String value) {
        Assert.notNull(value, "'value' cannot be null.");
        this.value = value;
    }

    public void setLabel(String label) {
        Assert.notNull(label, "'label' cannot be null.");
        this.label = label;
    }

    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        tagWriter.startTag("option");
        Object resolvedValue = this.evaluate("value", this.value);
        tagWriter.writeAttribute("value", ObjectUtils.nullSafeToString(resolvedValue));
        if (this.getSelectedValue().equals(resolvedValue)) {
            tagWriter.writeAttribute("selected", "true");
        }
        tagWriter.appendValue(this.getLabelValue(resolvedValue));
        tagWriter.endTag();
        return 6;
    }

    private String getLabelValue(Object resolvedValue) throws JspException {
        Object labelObj = this.label == null ? resolvedValue : this.evaluate("label", this.label);
        return ObjectUtils.nullSafeToString(labelObj);
    }

    private Object getSelectedValue() {
        Object selectedValue = this.pageContext.getAttribute("org.springframework.web.servlet.tags.form.SelectTag.listValue");
        if (selectedValue == null) {
            throw new IllegalStateException("The 'option' tag can only be used inside a valid 'select' tag.");
        }
        return selectedValue;
    }
}

