/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import java.util.Collection;
import javax.servlet.jsp.JspException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.servlet.tags.form.AbstractHtmlInputElementTag;
import org.springframework.web.servlet.tags.form.TagWriter;

public class CheckboxTag
extends AbstractHtmlInputElementTag {
    private String value;

    public void setValue(String value) {
        Assert.notNull(value, "'value' cannot be null.");
        this.value = value;
    }

    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        tagWriter.startTag("input");
        this.writeDefaultAttributes(tagWriter);
        tagWriter.writeAttribute("type", "checkbox");
        Object boundValue = this.getValue();
        if (boundValue instanceof Boolean) {
            this.renderFromBoolean((Boolean)boundValue, tagWriter);
        } else {
            if (this.value == null) {
                throw new IllegalArgumentException("Attribute 'value' is required when binding to non-Boolean values.");
            }
            Object resolvedValue = this.evaluate("value", this.value);
            if (boundValue != null && boundValue.getClass().isArray()) {
                this.renderFromCollection(resolvedValue, CollectionUtils.toList(boundValue), tagWriter);
            } else if (boundValue instanceof Collection) {
                this.renderFromCollection(resolvedValue, (Collection)boundValue, tagWriter);
            } else {
                this.renderSingleValue(resolvedValue, tagWriter);
            }
        }
        tagWriter.endTag();
        tagWriter.startTag("input");
        tagWriter.writeAttribute("type", "hidden");
        tagWriter.writeAttribute("boundValue", "1");
        tagWriter.writeAttribute("name", "_" + this.getPath());
        tagWriter.endTag();
        return 6;
    }

    private void renderSingleValue(Object resolvedValue, TagWriter tagWriter) throws JspException {
        tagWriter.writeAttribute("value", ObjectUtils.nullSafeToString(resolvedValue));
        if (this.isActiveValue(resolvedValue)) {
            tagWriter.writeAttribute("checked", "true");
        }
    }

    private void renderFromCollection(Object resolvedValue, Collection boundValue, TagWriter tagWriter) throws JspException {
        tagWriter.writeAttribute("value", ObjectUtils.nullSafeToString(resolvedValue));
        if (boundValue.contains(resolvedValue)) {
            tagWriter.writeAttribute("checked", "true");
        }
    }

    private void renderFromBoolean(Boolean boundValue, TagWriter tagWriter) throws JspException {
        tagWriter.writeAttribute("value", "true");
        if (boundValue.booleanValue()) {
            tagWriter.writeAttribute("checked", "true");
        }
    }
}

