/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public abstract class AbstractSingleBeanDefinitionParser
implements BeanDefinitionParser {
    public static final String ID_ATTRIBUTE = "id";

    public final BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder definitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(this.getBeanClass(element));
        this.doParse(element, definitionBuilder);
        AbstractBeanDefinition definition = definitionBuilder.getBeanDefinition();
        String id = element.getAttribute(ID_ATTRIBUTE);
        if (StringUtils.hasText(id)) {
            BeanDefinitionHolder holder = new BeanDefinitionHolder(definition, id);
            BeanDefinitionReaderUtils.registerBeanDefinition(holder, parserContext.getRegistry());
            parserContext.getReaderContext().fireComponentRegistered(new BeanComponentDefinition(holder));
        }
        return definition;
    }

    protected abstract Class getBeanClass(Element var1);

    protected void doParse(Element element, BeanDefinitionBuilder definitionBuilder) {
    }
}

