/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.AutowireUtils;
import org.springframework.beans.factory.support.BeanDefinitionValueResolver;
import org.springframework.beans.factory.support.CglibSubclassingInstantiationStrategy;
import org.springframework.beans.factory.support.ConstructorResolver;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractAutowireCapableBeanFactory
extends AbstractBeanFactory
implements AutowireCapableBeanFactory {
    private InstantiationStrategy instantiationStrategy = new CglibSubclassingInstantiationStrategy();
    private boolean allowCircularReferences = true;
    private final Set ignoredDependencyTypes = new HashSet();
    private final Set ignoredDependencyInterfaces = new HashSet();
    static /* synthetic */ Class class$org$springframework$beans$factory$BeanFactoryAware;

    public AbstractAutowireCapableBeanFactory() {
        this.ignoreDependencyInterface(class$org$springframework$beans$factory$BeanFactoryAware == null ? (class$org$springframework$beans$factory$BeanFactoryAware = AbstractAutowireCapableBeanFactory.class$("org.springframework.beans.factory.BeanFactoryAware")) : class$org$springframework$beans$factory$BeanFactoryAware);
    }

    public AbstractAutowireCapableBeanFactory(BeanFactory parentBeanFactory) {
        this();
        this.setParentBeanFactory(parentBeanFactory);
    }

    public void setInstantiationStrategy(InstantiationStrategy instantiationStrategy) {
        this.instantiationStrategy = instantiationStrategy;
    }

    public InstantiationStrategy getInstantiationStrategy() {
        return this.instantiationStrategy;
    }

    public void setAllowCircularReferences(boolean allowCircularReferences) {
        this.allowCircularReferences = allowCircularReferences;
    }

    public boolean isAllowCircularReferences() {
        return this.allowCircularReferences;
    }

    public void ignoreDependencyType(Class type) {
        this.ignoredDependencyTypes.add(type);
    }

    public Set getIgnoredDependencyTypes() {
        return this.ignoredDependencyTypes;
    }

    public void ignoreDependencyInterface(Class ifc) {
        this.ignoredDependencyInterfaces.add(ifc);
    }

    public Set getIgnoredDependencyInterfaces() {
        return this.ignoredDependencyInterfaces;
    }

    public Object createBean(Class beanClass, int autowireMode, boolean dependencyCheck) throws BeansException {
        RootBeanDefinition bd = new RootBeanDefinition(beanClass, autowireMode, dependencyCheck);
        bd.setSingleton(false);
        return this.createBean(beanClass.getName(), bd, null);
    }

    public Object autowire(Class beanClass, int autowireMode, boolean dependencyCheck) throws BeansException {
        RootBeanDefinition bd = new RootBeanDefinition(beanClass, autowireMode, dependencyCheck);
        bd.setSingleton(false);
        if (bd.getResolvedAutowireMode() == 3) {
            return this.autowireConstructor(beanClass.getName(), bd).getWrappedInstance();
        }
        Object bean = this.instantiationStrategy.instantiate(bd, null, this);
        this.populateBean(beanClass.getName(), bd, new BeanWrapperImpl(bean));
        return bean;
    }

    public void autowireBeanProperties(Object existingBean, int autowireMode, boolean dependencyCheck) throws BeansException {
        if (autowireMode != 1 && autowireMode != 2) {
            throw new IllegalArgumentException("Just constants AUTOWIRE_BY_NAME and AUTOWIRE_BY_TYPE allowed");
        }
        RootBeanDefinition bd = new RootBeanDefinition(existingBean.getClass(), autowireMode, dependencyCheck);
        bd.setSingleton(false);
        this.populateBean(existingBean.getClass().getName(), bd, new BeanWrapperImpl(existingBean));
    }

    public void applyBeanPropertyValues(Object existingBean, String beanName) throws BeansException {
        RootBeanDefinition bd = this.getMergedBeanDefinition(beanName, true);
        BeanWrapperImpl bw = new BeanWrapperImpl(existingBean);
        this.initBeanWrapper(bw);
        this.applyPropertyValues(beanName, bd, bw, bd.getPropertyValues());
    }

    public Object configureBean(Object existingBean, String beanName) throws BeansException {
        RootBeanDefinition bd = this.getMergedBeanDefinition(beanName, true);
        BeanWrapperImpl bw = new BeanWrapperImpl(existingBean);
        this.initBeanWrapper(bw);
        this.populateBean(beanName, bd, bw);
        return this.initializeBean(beanName, existingBean, bd);
    }

    public Object initializeBean(Object existingBean, String beanName) {
        return this.initializeBean(beanName, existingBean, null);
    }

    protected Object applyBeanPostProcessorsBeforeInstantiation(Class beanClass, String beanName) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking BeanPostProcessors before instantiation of bean '" + beanName + "'"));
        }
        Iterator it = this.getBeanPostProcessors().iterator();
        while (it.hasNext()) {
            Object result;
            BeanPostProcessor beanProcessor = (BeanPostProcessor)it.next();
            if (!(beanProcessor instanceof InstantiationAwareBeanPostProcessor) || (result = ((InstantiationAwareBeanPostProcessor)beanProcessor).postProcessBeforeInstantiation(beanClass, beanName)) == null) continue;
            return result;
        }
        return null;
    }

    public Object applyBeanPostProcessorsBeforeInitialization(Object existingBean, String beanName) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking BeanPostProcessors before initialization of bean '" + beanName + "'"));
        }
        Object result = existingBean;
        Iterator it = this.getBeanPostProcessors().iterator();
        while (it.hasNext()) {
            BeanPostProcessor beanProcessor = (BeanPostProcessor)it.next();
            result = beanProcessor.postProcessBeforeInitialization(result, beanName);
            if (result != null) continue;
            throw new BeanCreationException(beanName, "postProcessBeforeInitialization method of BeanPostProcessor [" + beanProcessor + "] returned null for bean [" + result + "] with name [" + beanName + "]");
        }
        return result;
    }

    public Object applyBeanPostProcessorsAfterInitialization(Object existingBean, String beanName) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking BeanPostProcessors after initialization of bean '" + beanName + "'"));
        }
        Object result = existingBean;
        Iterator it = this.getBeanPostProcessors().iterator();
        while (it.hasNext()) {
            BeanPostProcessor beanProcessor = (BeanPostProcessor)it.next();
            result = beanProcessor.postProcessAfterInitialization(result, beanName);
            if (result != null) continue;
            throw new BeanCreationException(beanName, "postProcessAfterInitialization method of BeanPostProcessor [" + beanProcessor + "] returned null for bean [" + result + "] with name [" + beanName + "]");
        }
        return result;
    }

    protected Object createBean(String beanName, RootBeanDefinition mergedBeanDefinition, Object[] args) throws BeanCreationException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating instance of bean '" + beanName + "' with merged definition [" + mergedBeanDefinition + "]"));
        }
        Object bean = null;
        if (mergedBeanDefinition.hasBeanClass() && (bean = this.applyBeanPostProcessorsBeforeInstantiation(mergedBeanDefinition.getBeanClass(), beanName)) != null) {
            return bean;
        }
        if (mergedBeanDefinition.getDependsOn() != null) {
            for (int i = 0; i < mergedBeanDefinition.getDependsOn().length; ++i) {
                this.getBean(mergedBeanDefinition.getDependsOn()[i]);
            }
        }
        BeanWrapper instanceWrapper = null;
        Object originalBean = null;
        String errorMessage = null;
        try {
            errorMessage = "Instantiation of bean failed";
            instanceWrapper = mergedBeanDefinition.getFactoryMethodName() != null ? this.instantiateUsingFactoryMethod(beanName, mergedBeanDefinition, args) : (mergedBeanDefinition.getResolvedAutowireMode() == 3 || mergedBeanDefinition.hasConstructorArgumentValues() ? this.autowireConstructor(beanName, mergedBeanDefinition) : this.instantiateBean(beanName, mergedBeanDefinition));
            bean = instanceWrapper.getWrappedInstance();
            if (this.isAllowCircularReferences() && this.isSingletonCurrentlyInCreation(beanName)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Eagerly caching bean with name '" + beanName + "' to allow for resolving potential circular references"));
                }
                this.addSingleton(beanName, bean);
            }
            errorMessage = "Initialization of bean failed";
            boolean continueWithPropertyPopulation = true;
            Iterator it = this.getBeanPostProcessors().iterator();
            while (it.hasNext()) {
                BeanPostProcessor beanProcessor = (BeanPostProcessor)it.next();
                if (!(beanProcessor instanceof InstantiationAwareBeanPostProcessor) || ((InstantiationAwareBeanPostProcessor)beanProcessor).postProcessAfterInstantiation(bean, beanName)) continue;
                continueWithPropertyPopulation = false;
                break;
            }
            if (continueWithPropertyPopulation) {
                this.populateBean(beanName, mergedBeanDefinition, instanceWrapper);
            }
            originalBean = bean;
            bean = this.initializeBean(beanName, bean, mergedBeanDefinition);
        }
        catch (BeanCreationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, errorMessage, ex);
        }
        this.registerDisposableBeanIfNecessary(beanName, originalBean, mergedBeanDefinition);
        return bean;
    }

    protected Class getTypeForFactoryMethod(String beanName, RootBeanDefinition mergedBeanDefinition) {
        Class factoryClass = null;
        boolean isStatic = true;
        if (mergedBeanDefinition.getFactoryBeanName() != null) {
            factoryClass = this.getType(mergedBeanDefinition.getFactoryBeanName());
            isStatic = false;
        } else {
            if (!mergedBeanDefinition.hasBeanClass()) {
                return null;
            }
            factoryClass = mergedBeanDefinition.getBeanClass();
        }
        int minNrOfArgs = mergedBeanDefinition.getConstructorArgumentValues().getArgumentCount();
        Method[] candidates = ReflectionUtils.getAllDeclaredMethods(factoryClass);
        HashSet returnTypes = new HashSet(1);
        for (int i = 0; i < candidates.length; ++i) {
            Method factoryMethod = candidates[i];
            if (Modifier.isStatic(factoryMethod.getModifiers()) != isStatic || !factoryMethod.getName().equals(mergedBeanDefinition.getFactoryMethodName()) || factoryMethod.getParameterTypes().length < minNrOfArgs) continue;
            returnTypes.add(factoryMethod.getReturnType());
        }
        if (returnTypes.size() == 1) {
            return (Class)returnTypes.iterator().next();
        }
        return null;
    }

    protected BeanWrapper instantiateBean(String beanName, RootBeanDefinition mergedBeanDefinition) throws BeansException {
        Object beanInstance = this.getInstantiationStrategy().instantiate(mergedBeanDefinition, beanName, this);
        BeanWrapperImpl bw = new BeanWrapperImpl(beanInstance);
        this.initBeanWrapper(bw);
        return bw;
    }

    protected BeanWrapper instantiateUsingFactoryMethod(String beanName, RootBeanDefinition mergedBeanDefinition, Object[] explicitArgs) throws BeansException {
        ConstructorResolverAdapter constructorResolver = new ConstructorResolverAdapter();
        return constructorResolver.instantiateUsingFactoryMethod(beanName, mergedBeanDefinition, explicitArgs);
    }

    protected BeanWrapper autowireConstructor(String beanName, RootBeanDefinition mergedBeanDefinition) throws BeansException {
        ConstructorResolverAdapter constructorResolver = new ConstructorResolverAdapter();
        return constructorResolver.autowireConstructor(beanName, mergedBeanDefinition);
    }

    protected void populateBean(String beanName, RootBeanDefinition mergedBeanDefinition, BeanWrapper bw) throws BeansException {
        MutablePropertyValues pvs = mergedBeanDefinition.getPropertyValues();
        if (mergedBeanDefinition.getResolvedAutowireMode() == 1 || mergedBeanDefinition.getResolvedAutowireMode() == 2) {
            MutablePropertyValues mpvs = new MutablePropertyValues(pvs);
            if (mergedBeanDefinition.getResolvedAutowireMode() == 1) {
                this.autowireByName(beanName, mergedBeanDefinition, bw, mpvs);
            }
            if (mergedBeanDefinition.getResolvedAutowireMode() == 2) {
                this.autowireByType(beanName, mergedBeanDefinition, bw, mpvs);
            }
            pvs = mpvs;
        }
        this.checkDependencies(beanName, mergedBeanDefinition, bw, pvs);
        this.applyPropertyValues(beanName, mergedBeanDefinition, bw, pvs);
    }

    protected void autowireByName(String beanName, RootBeanDefinition mergedBeanDefinition, BeanWrapper bw, MutablePropertyValues pvs) throws BeansException {
        String[] propertyNames = this.unsatisfiedNonSimpleProperties(mergedBeanDefinition, bw);
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            if (this.containsBean(propertyName)) {
                Object bean = this.getBean(propertyName);
                pvs.addPropertyValue(propertyName, bean);
                if (mergedBeanDefinition.isSingleton()) {
                    this.registerDependentBean(propertyName, beanName);
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Added autowiring by name from bean name '" + beanName + "' via property '" + propertyName + "' to bean named '" + propertyName + "'"));
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Not autowiring property '" + propertyName + "' of bean '" + beanName + "' by name: no matching bean found"));
        }
    }

    protected void autowireByType(String beanName, RootBeanDefinition mergedBeanDefinition, BeanWrapper bw, MutablePropertyValues pvs) throws BeansException {
        String[] propertyNames = this.unsatisfiedNonSimpleProperties(mergedBeanDefinition, bw);
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            Class<?> requiredType = bw.getPropertyDescriptor(propertyName).getPropertyType();
            Map matchingBeans = this.findMatchingBeans(requiredType);
            if (matchingBeans != null && matchingBeans.size() == 1) {
                String autowiredBeanName = (String)matchingBeans.keySet().iterator().next();
                Object autowiredBean = matchingBeans.values().iterator().next();
                pvs.addPropertyValue(propertyName, autowiredBean);
                if (mergedBeanDefinition.isSingleton()) {
                    this.registerDependentBean(autowiredBeanName, beanName);
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Autowiring by type from bean name '" + beanName + "' via property '" + propertyName + "' to bean named '" + autowiredBeanName + "'"));
                continue;
            }
            if (matchingBeans != null && matchingBeans.size() > 1) {
                throw new UnsatisfiedDependencyException(mergedBeanDefinition.getResourceDescription(), beanName, propertyName, "There are " + matchingBeans.size() + " beans of type [" + requiredType + "] for autowire by type. There should have been 1 to be able to autowire property '" + propertyName + "' of bean '" + beanName + "'.");
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Not autowiring property '" + propertyName + "' of bean '" + beanName + "' by type: no matching bean found"));
        }
    }

    protected String[] unsatisfiedNonSimpleProperties(RootBeanDefinition mergedBeanDefinition, BeanWrapper bw) {
        TreeSet<String> result = new TreeSet<String>();
        MutablePropertyValues pvs = mergedBeanDefinition.getPropertyValues();
        PropertyDescriptor[] pds = bw.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            if (pds[i].getWriteMethod() == null || this.isExcludedFromDependencyCheck(pds[i]) || pvs.contains(pds[i].getName()) || BeanUtils.isSimpleProperty(pds[i].getPropertyType())) continue;
            result.add(pds[i].getName());
        }
        return StringUtils.toStringArray(result);
    }

    protected void checkDependencies(String beanName, RootBeanDefinition mergedBeanDefinition, BeanWrapper bw, PropertyValues pvs) throws UnsatisfiedDependencyException {
        int dependencyCheck = mergedBeanDefinition.getDependencyCheck();
        if (dependencyCheck == 0) {
            return;
        }
        PropertyDescriptor[] pds = bw.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            boolean unsatisfied;
            if (pds[i].getWriteMethod() == null || this.isExcludedFromDependencyCheck(pds[i]) || pvs.contains(pds[i].getName())) continue;
            boolean isSimple = BeanUtils.isSimpleProperty(pds[i].getPropertyType());
            boolean bl = unsatisfied = dependencyCheck == 3 || isSimple && dependencyCheck == 2 || !isSimple && dependencyCheck == 1;
            if (!unsatisfied) continue;
            throw new UnsatisfiedDependencyException(mergedBeanDefinition.getResourceDescription(), beanName, pds[i].getName(), "set this property value or disable dependency checking for this bean");
        }
    }

    protected boolean isExcludedFromDependencyCheck(PropertyDescriptor pd) {
        return AutowireUtils.isExcludedFromDependencyCheck(pd) || this.getIgnoredDependencyTypes().contains(pd.getPropertyType()) || AutowireUtils.isSetterDefinedInInterface(pd, this.getIgnoredDependencyInterfaces());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyPropertyValues(String beanName, RootBeanDefinition mergedBeanDefinition, BeanWrapper bw, PropertyValues pvs) throws BeansException {
        block8: {
            if (pvs == null) {
                return;
            }
            BeanDefinitionValueResolver valueResolver = new BeanDefinitionValueResolver(this, beanName, mergedBeanDefinition);
            MutablePropertyValues deepCopy = new MutablePropertyValues();
            PropertyValue[] pvArray = pvs.getPropertyValues();
            for (int i = 0; i < pvArray.length; ++i) {
                PropertyValue pv = pvArray[i];
                Object resolvedValue = valueResolver.resolveValueIfNecessary("bean property '" + pv.getName() + "'", pv.getValue());
                deepCopy.addPropertyValue(pvArray[i].getName(), resolvedValue);
            }
            try {
                if (!this.getCustomEditors().isEmpty()) {
                    AbstractAutowireCapableBeanFactory i = this;
                    synchronized (i) {
                        bw.setPropertyValues(deepCopy);
                        break block8;
                    }
                }
                bw.setPropertyValues(deepCopy);
            }
            catch (BeansException ex) {
                throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, "Error setting property values", ex);
            }
        }
    }

    protected Object initializeBean(String beanName, Object bean, RootBeanDefinition mergedBeanDefinition) throws BeansException {
        if (bean instanceof BeanNameAware) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Invoking setBeanName on BeanNameAware bean '" + beanName + "'"));
            }
            ((BeanNameAware)bean).setBeanName(beanName);
        }
        if (bean instanceof BeanFactoryAware) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Invoking setBeanFactory on BeanFactoryAware bean '" + beanName + "'"));
            }
            ((BeanFactoryAware)bean).setBeanFactory(this);
        }
        Object wrappedBean = bean;
        wrappedBean = this.applyBeanPostProcessorsBeforeInitialization(wrappedBean, beanName);
        try {
            this.invokeInitMethods(beanName, wrappedBean, mergedBeanDefinition);
        }
        catch (Throwable ex) {
            throw new BeanCreationException(mergedBeanDefinition != null ? mergedBeanDefinition.getResourceDescription() : null, beanName, "Invocation of init method failed", ex);
        }
        wrappedBean = this.applyBeanPostProcessorsAfterInitialization(wrappedBean, beanName);
        return wrappedBean;
    }

    protected void invokeInitMethods(String beanName, Object bean, RootBeanDefinition mergedBeanDefinition) throws Throwable {
        if (bean instanceof InitializingBean) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Invoking afterPropertiesSet() on bean with name '" + beanName + "'"));
            }
            ((InitializingBean)bean).afterPropertiesSet();
        }
        if (mergedBeanDefinition != null && mergedBeanDefinition.getInitMethodName() != null) {
            this.invokeCustomInitMethod(beanName, bean, mergedBeanDefinition.getInitMethodName(), mergedBeanDefinition.isEnforceInitMethod());
        }
    }

    protected void invokeCustomInitMethod(String beanName, Object bean, String initMethodName, boolean enforceInitMethod) throws Throwable {
        Method initMethod;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking custom init method '" + initMethodName + "' on bean with name '" + beanName + "'"));
        }
        if ((initMethod = BeanUtils.findMethod(bean.getClass(), initMethodName, null)) == null) {
            if (enforceInitMethod) {
                throw new NoSuchMethodException("Couldn't find an init method named '" + initMethodName + "' on bean with name '" + beanName + "'");
            }
            return;
        }
        if (!Modifier.isPublic(initMethod.getModifiers())) {
            initMethod.setAccessible(true);
        }
        try {
            initMethod.invoke(bean, (Object[])null);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }

    protected abstract Map findMatchingBeans(Class var1) throws BeansException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ConstructorResolverAdapter
    extends ConstructorResolver {
        public ConstructorResolverAdapter() {
            super(AbstractAutowireCapableBeanFactory.this, AbstractAutowireCapableBeanFactory.this.getInstantiationStrategy());
        }

        protected Map findMatchingBeans(Class requiredType) throws BeansException {
            return AbstractAutowireCapableBeanFactory.this.findMatchingBeans(requiredType);
        }
    }
}

