/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.scope;

import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.context.scope.RequestContextHolder;

public class RequestContextListener
implements ServletRequestListener {
    public void requestInitialized(ServletRequestEvent requestEvent) {
        if (!(requestEvent.getServletRequest() instanceof HttpServletRequest)) {
            throw new IllegalArgumentException("Request is not an HttpServletRequest: " + requestEvent.getServletRequest());
        }
        HttpServletRequest request = (HttpServletRequest)requestEvent.getServletRequest();
        LocaleContextHolder.setLocale(request.getLocale());
        RequestContextHolder.setRequest(request);
    }

    public void requestDestroyed(ServletRequestEvent requestEvent) {
        RequestContextHolder.setRequest(null);
        LocaleContextHolder.setLocale(null);
    }
}

