/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.config;

import java.util.HashMap;
import java.util.List;
import org.springframework.aop.config.NamespaceHandlerUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.util.ClassUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class TxNamespaceHandler
extends NamespaceHandlerSupport {
    private static final String TRANSACTION_MANAGER = "transactionManager";
    private static final String TRANSACTION_ATTRIBUTE_SOURCE = "transactionAttributeSource";
    private static final String ANNOTATION_SOURCE_CLASS_NAME = "org.springframework.transaction.annotation.AnnotationTransactionAttributeSource";
    static /* synthetic */ Class class$org$springframework$transaction$interceptor$TransactionInterceptor;
    static /* synthetic */ Class class$org$springframework$transaction$interceptor$TransactionAttributeSourceAdvisor;
    static /* synthetic */ Class class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource;

    public TxNamespaceHandler() {
        this.registerBeanDefinitionParser("advice", new TxAdviceBeanDefinitionParser());
        this.registerBeanDefinitionParser("annotation-driven", new AnnotationDrivenBeanDefinitionParser());
    }

    private static Class getAnnotationSourceClass() {
        try {
            return ClassUtils.forName(ANNOTATION_SOURCE_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to locate AnnotationTransactionAttributeSource. Are you running on Java 1.5?");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class TxAdviceBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private static final String ATTRIBUTES = "attributes";
        public static final String TIMEOUT = "timeout";
        public static final String READ_ONLY = "read-only";
        public static final String NAME_MAP = "nameMap";
        public static final String PROPAGATION = "propagation";
        public static final String ISOLATION = "isolation";

        private TxAdviceBeanDefinitionParser() {
        }

        protected BeanDefinition doParse(Element element) {
            RootBeanDefinition definition = new RootBeanDefinition(class$org$springframework$transaction$interceptor$TransactionInterceptor == null ? (class$org$springframework$transaction$interceptor$TransactionInterceptor = TxNamespaceHandler.class$("org.springframework.transaction.interceptor.TransactionInterceptor")) : class$org$springframework$transaction$interceptor$TransactionInterceptor);
            MutablePropertyValues mpvs = new MutablePropertyValues();
            definition.setPropertyValues(mpvs);
            mpvs.addPropertyValue(TxNamespaceHandler.TRANSACTION_MANAGER, new RuntimeBeanReference(element.getAttribute(TxNamespaceHandler.TRANSACTION_MANAGER)));
            List txAttributes = DomUtils.getChildElementsByTagName(element, ATTRIBUTES, true);
            if (txAttributes.size() > 1) {
                throw new IllegalStateException("Element 'attributes' is allowed at most once inside element 'advice'");
            }
            if (txAttributes.size() == 1) {
                this.parseAttributes((Element)txAttributes.get(0), mpvs);
            } else {
                Class beanClass = TxNamespaceHandler.getAnnotationSourceClass();
                mpvs.addPropertyValue(TxNamespaceHandler.TRANSACTION_ATTRIBUTE_SOURCE, new RootBeanDefinition(beanClass));
            }
            return definition;
        }

        private void parseAttributes(Element attributesElement, MutablePropertyValues mpvs) {
            List methods = DomUtils.getChildElementsByTagName(attributesElement, "method", true);
            HashMap<String, RuleBasedTransactionAttribute> transactionAttributeMap = new HashMap<String, RuleBasedTransactionAttribute>(methods.size());
            for (int i = 0; i < methods.size(); ++i) {
                Element methodElement = (Element)methods.get(i);
                String name = methodElement.getAttribute("name");
                RuleBasedTransactionAttribute attribute = new RuleBasedTransactionAttribute();
                attribute.setPropagationBehaviorName("PROPAGATION_" + methodElement.getAttribute(PROPAGATION));
                attribute.setIsolationLevelName("ISOLATION_" + methodElement.getAttribute(ISOLATION));
                attribute.setTimeout(Integer.parseInt(methodElement.getAttribute(TIMEOUT)));
                attribute.setReadOnly(Boolean.valueOf(methodElement.getAttribute(READ_ONLY)));
                transactionAttributeMap.put(name, attribute);
            }
            RootBeanDefinition attributeSourceDefinition = new RootBeanDefinition(class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource == null ? (class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource = TxNamespaceHandler.class$("org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource")) : class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource);
            attributeSourceDefinition.setPropertyValues(new MutablePropertyValues());
            attributeSourceDefinition.getPropertyValues().addPropertyValue(NAME_MAP, transactionAttributeMap);
            mpvs.addPropertyValue(TxNamespaceHandler.TRANSACTION_ATTRIBUTE_SOURCE, attributeSourceDefinition);
        }
    }

    private static class AnnotationDrivenBeanDefinitionParser
    implements BeanDefinitionParser {
        private static final String TRANSACTION_ATTRIBUTE_SOURCE_ADVISOR_NAME = ".transactionAttributeSourceAdvisor";
        public static final String TRANSACTION_INTERCEPTOR = "transactionInterceptor";

        private AnnotationDrivenBeanDefinitionParser() {
        }

        public void parse(Element element, BeanDefinitionRegistry registry) {
            NamespaceHandlerUtils.registerAutoProxyCreatorIfNecessary(registry);
            String transactionManagerName = element.getAttribute(TxNamespaceHandler.TRANSACTION_MANAGER);
            RootBeanDefinition interceptorDefinition = new RootBeanDefinition(class$org$springframework$transaction$interceptor$TransactionInterceptor == null ? (class$org$springframework$transaction$interceptor$TransactionInterceptor = TxNamespaceHandler.class$("org.springframework.transaction.interceptor.TransactionInterceptor")) : class$org$springframework$transaction$interceptor$TransactionInterceptor);
            interceptorDefinition.setPropertyValues(new MutablePropertyValues());
            interceptorDefinition.getPropertyValues().addPropertyValue(TxNamespaceHandler.TRANSACTION_MANAGER, new RuntimeBeanReference(transactionManagerName));
            interceptorDefinition.getPropertyValues().addPropertyValue(TxNamespaceHandler.TRANSACTION_ATTRIBUTE_SOURCE, new RootBeanDefinition(TxNamespaceHandler.getAnnotationSourceClass()));
            RootBeanDefinition advisorDefinition = new RootBeanDefinition(class$org$springframework$transaction$interceptor$TransactionAttributeSourceAdvisor == null ? (class$org$springframework$transaction$interceptor$TransactionAttributeSourceAdvisor = TxNamespaceHandler.class$("org.springframework.transaction.interceptor.TransactionAttributeSourceAdvisor")) : class$org$springframework$transaction$interceptor$TransactionAttributeSourceAdvisor);
            advisorDefinition.setPropertyValues(new MutablePropertyValues());
            advisorDefinition.getPropertyValues().addPropertyValue(TRANSACTION_INTERCEPTOR, interceptorDefinition);
            registry.registerBeanDefinition(TRANSACTION_ATTRIBUTE_SOURCE_ADVISOR_NAME, advisorDefinition);
        }
    }
}

