/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.simple;

import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleJdbcTemplate
implements SimpleJdbcOperations {
    private final JdbcOperations classicJdbcTemplate;

    public SimpleJdbcTemplate(DataSource dataSource) {
        this.classicJdbcTemplate = new JdbcTemplate(dataSource);
    }

    public SimpleJdbcTemplate(JdbcOperations jdbcTemplate) {
        this.classicJdbcTemplate = jdbcTemplate;
    }

    @Override
    public JdbcOperations getJdbcOperations() {
        return this.classicJdbcTemplate;
    }

    @Override
    public int queryForInt(String sql, Object ... args) throws DataAccessException {
        return args == null || args.length == 0 ? this.classicJdbcTemplate.queryForInt(sql) : this.classicJdbcTemplate.queryForInt(sql, args);
    }

    @Override
    public long queryForLong(String sql, Object ... args) throws DataAccessException {
        return args == null || args.length == 0 ? this.classicJdbcTemplate.queryForLong(sql) : this.classicJdbcTemplate.queryForLong(sql, args);
    }

    @Override
    public <T> T queryForObject(String sql, Class<T> requiredType, Object ... args) throws DataAccessException {
        return (T)(args == null || args.length == 0 ? this.classicJdbcTemplate.queryForObject(sql, requiredType) : this.classicJdbcTemplate.queryForObject(sql, args, requiredType));
    }

    @Override
    public <T> T queryForObject(String sql, ParameterizedRowMapper<T> rm, Object ... args) throws DataAccessException {
        return (T)(args == null || args.length == 0 ? this.classicJdbcTemplate.queryForObject(sql, rm) : this.classicJdbcTemplate.queryForObject(sql, args, rm));
    }

    @Override
    public <T> List<T> query(String sql, ParameterizedRowMapper<T> rm, Object ... args) throws DataAccessException {
        return args == null || args.length == 0 ? this.classicJdbcTemplate.query(sql, rm) : this.classicJdbcTemplate.query(sql, args, rm);
    }

    @Override
    public Map<String, Object> queryForMap(String sql, Object ... args) throws DataAccessException {
        return args == null || args.length == 0 ? this.classicJdbcTemplate.queryForMap(sql) : this.classicJdbcTemplate.queryForMap(sql, args);
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql, Object ... args) throws DataAccessException {
        return args == null || args.length == 0 ? this.classicJdbcTemplate.queryForList(sql) : this.classicJdbcTemplate.queryForList(sql, args);
    }

    @Override
    public int update(String sql, Object ... args) throws DataAccessException {
        return args == null || args.length == 0 ? this.classicJdbcTemplate.update(sql) : this.classicJdbcTemplate.update(sql, args);
    }
}

