/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.springframework.core.ParameterNameDiscoverer;

public class PrioritizedParameterNameDiscoverer
implements ParameterNameDiscoverer {
    private static ParameterNameDiscoverer RETURNS_NULL = new ParameterNameDiscoverer(){

        public String[] getParameterNames(Method m, Class clazz) {
            return null;
        }

        public String[] getParameterNames(Constructor ctor) {
            return null;
        }
    };
    private List parameterNameDiscoverers = new LinkedList();

    public PrioritizedParameterNameDiscoverer() {
        this.parameterNameDiscoverers.add(RETURNS_NULL);
    }

    public void addDiscoverer(ParameterNameDiscoverer pnd) {
        this.parameterNameDiscoverers.add(this.parameterNameDiscoverers.size() - 1, pnd);
    }

    public String[] getParameterNames(Method m, Class clazz) {
        Iterator it = this.parameterNameDiscoverers.iterator();
        while (it.hasNext()) {
            ParameterNameDiscoverer pmd = (ParameterNameDiscoverer)it.next();
            String[] result = pmd.getParameterNames(m, clazz);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public String[] getParameterNames(Constructor ctor) {
        Iterator it = this.parameterNameDiscoverers.iterator();
        while (it.hasNext()) {
            ParameterNameDiscoverer pmd = (ParameterNameDiscoverer)it.next();
            String[] result = pmd.getParameterNames(ctor);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

